/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.selection;

import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ReplaceListDataProvider;
import com.vaadin.data.provider.StrBean;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.Grid;
import com.vaadin.ui.UI;
import com.vaadin.ui.components.grid.GridSelectionModel;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridStaleElementTest {
    private Grid<StrBean> grid = new Grid();
    private ReplaceListDataProvider dataProvider;
    private List<StrBean> data = StrBean.generateRandomBeans(2);

    @Before
    public void setUp() {
        final AlwaysLockedVaadinSession application = new AlwaysLockedVaadinSession(null);
        UI uI = new UI(){

            protected void init(VaadinRequest request) {
            }

            public VaadinSession getSession() {
                return application;
            }

            public Future<Void> access(Runnable runnable) {
                runnable.run();
                return null;
            }
        };
        uI.setContent(this.grid);
        uI.attach();
        this.dataProvider = new ReplaceListDataProvider(this.data);
        this.grid.setDataProvider((DataProvider)this.dataProvider);
    }

    @Test
    public void testGridMultiSelectionUpdateOnRefreshItem() {
        StrBean toReplace = this.data.get(0);
        this.assertNotStale(toReplace);
        GridSelectionModel model = this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        model.select((Object)toReplace);
        StrBean replacement = new StrBean("Replacement bean", toReplace.getId(), -1);
        this.dataProvider.refreshItem(replacement);
        this.assertStale(toReplace);
        model.getSelectedItems().forEach(item -> Assert.assertFalse((String)"Selection should not contain stale values", (boolean)this.dataProvider.isStale((StrBean)item)));
        Object oldId = this.dataProvider.getId(toReplace);
        Assert.assertTrue((String)"Selection did not contain an item with matching Id.", (boolean)model.getSelectedItems().stream().map(this.dataProvider::getId).anyMatch(oldId::equals));
        Assert.assertTrue((String)"Stale element is not considered selected.", (boolean)model.isSelected((Object)toReplace));
    }

    @Test
    public void testGridSingleSelectionUpdateOnRefreshItem() {
        StrBean toReplace = this.data.get(0);
        this.assertNotStale(toReplace);
        GridSelectionModel model = this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        model.select((Object)toReplace);
        StrBean replacement = new StrBean("Replacement bean", toReplace.getId(), -1);
        this.dataProvider.refreshItem(replacement);
        this.assertStale(toReplace);
        model.getSelectedItems().forEach(i -> Assert.assertFalse((String)"Selection should not contain stale values", (boolean)this.dataProvider.isStale((StrBean)i)));
        Assert.assertTrue((String)"Selection did not contain an item with matching Id.", (boolean)model.getSelectedItems().stream().map(this.dataProvider::getId).filter(i -> this.dataProvider.getId(toReplace).equals(i)).findFirst().isPresent());
        Assert.assertTrue((String)"Stale element is not considered selected.", (boolean)model.isSelected((Object)toReplace));
    }

    private void assertNotStale(StrBean bean) {
        Assert.assertFalse((String)("Bean with id " + bean.getId() + " should not be stale."), (boolean)this.dataProvider.isStale(bean));
    }

    private void assertStale(StrBean bean) {
        Assert.assertTrue((String)("Bean with id " + bean.getId() + " should be stale."), (boolean)this.dataProvider.isStale(bean));
    }
}

