/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.selection;

import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ReplaceListDataProvider;
import com.vaadin.data.provider.StrBean;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.AbstractListing;
import com.vaadin.ui.UI;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractStaleSelectionTest<S extends AbstractListing<StrBean>> {
    protected ReplaceListDataProvider dataProvider;
    protected final List<StrBean> data = StrBean.generateRandomBeans(2);
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public S select;

    @Before
    public void setUp() {
        this.dataProvider = new ReplaceListDataProvider(this.data);
        final AlwaysLockedVaadinSession application = new AlwaysLockedVaadinSession(null);
        UI uI = new UI(){

            protected void init(VaadinRequest request) {
            }

            public VaadinSession getSession() {
                return application;
            }

            public Future<Void> access(Runnable runnable) {
                runnable.run();
                return null;
            }
        };
        uI.setContent(this.select);
        uI.attach();
        this.select.getDataCommunicator().setDataProvider((DataProvider)this.dataProvider, null);
    }

    protected final void assertIsStale(StrBean bean) {
        Assert.assertTrue((String)("Bean with id " + bean.getId() + " should be stale."), (boolean)this.dataProvider.isStale(bean));
    }

    protected final void assertNotStale(StrBean bean) {
        Assert.assertFalse((String)("Bean with id " + bean.getId() + " should not be stale."), (boolean)this.dataProvider.isStale(bean));
    }
}

