/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToLongConverter;
import com.vaadin.tests.data.converter.AbstractStringConverterTest;
import org.junit.Assert;
import org.junit.Test;

public class StringToLongConverterTest
extends AbstractStringConverterTest {
    protected StringToLongConverter getConverter() {
        return new StringToLongConverter(this.getErrorMessage());
    }

    @Override
    @Test
    public void testEmptyStringConversion() {
        this.assertValue(null, this.getConverter().convertToModel("", new ValueContext()));
    }

    @Test
    public void testValueConversion() {
        this.assertValue(10L, this.getConverter().convertToModel("10", new ValueContext()));
    }

    @Test
    public void testExtremeLongValueConversion() {
        Result l = this.getConverter().convertToModel("9223372036854775807", new ValueContext());
        this.assertValue(Long.MAX_VALUE, l);
        l = this.getConverter().convertToModel("-9223372036854775808", new ValueContext());
        this.assertValue(Long.MIN_VALUE, l);
    }

    @Test
    public void testOutOfBoundsValueConversion() {
        Result l = this.getConverter().convertToModel("9223372036854775808", new ValueContext());
        this.assertValue(Long.MAX_VALUE, l);
        l = this.getConverter().convertToModel("-9223372036854775809", new ValueContext());
        this.assertValue(Long.MIN_VALUE, l);
    }

    @Test
    public void customEmptyValue() {
        StringToLongConverter converter = new StringToLongConverter(Long.valueOf(0L), this.getErrorMessage());
        this.assertValue(0L, converter.convertToModel("", new ValueContext()));
        Assert.assertEquals((Object)"0", (Object)converter.convertToPresentation((Number)0L, new ValueContext()));
    }
}

