/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.ui.Grid;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class GridValueProvider {
    @Test
    public void getExplicitValueProvider() {
        Grid grid = new Grid();
        Grid.Column col = grid.addColumn((ValueProvider & Serializable)person -> person.getFirstName() + " " + person.getLastName());
        Person person2 = new Person("first", "last", "email", 123, Sex.UNKNOWN, null);
        Assert.assertEquals((Object)"first last", (Object)col.getValueProvider().apply((Object)person2));
    }

    @Test
    public void getBeanColumnValueProvider() {
        Grid grid = new Grid(Person.class);
        Grid.Column col = grid.getColumn("email");
        Person person = new Person("first", "last", "eeemaaail", 123, Sex.UNKNOWN, null);
        Assert.assertEquals((Object)"eeemaaail", (Object)col.getValueProvider().apply((Object)person));
    }

    @Test
    public void reuseValueProviderForFilter() {
        Grid grid = new Grid(Person.class);
        Grid.Column col = grid.getColumn("email");
        Person lowerCasePerson = new Person("first", "last", "email", 123, Sex.UNKNOWN, null);
        Person upperCasePerson = new Person("FIRST", "LAST", "EMAIL", 123, Sex.UNKNOWN, null);
        ListDataProvider persons = DataProvider.ofItems((Object[])new Person[]{lowerCasePerson, upperCasePerson});
        persons.addFilter(col.getValueProvider(), (SerializablePredicate & Serializable)value -> value.toUpperCase(Locale.ROOT).equals(value));
        List queryPersons = persons.fetch(new Query()).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)queryPersons.size());
        Assert.assertSame((Object)upperCasePerson, queryPersons.get(0));
    }
}

