/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.SelectionModel;
import com.vaadin.server.Extension;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.GridMultiSelect;
import com.vaadin.ui.components.grid.GridSingleSelect;
import com.vaadin.ui.components.grid.MultiSelectionModel;
import com.vaadin.ui.components.grid.MultiSelectionModelImpl;
import com.vaadin.ui.components.grid.NoSelectionModel;
import com.vaadin.ui.components.grid.SingleSelectionModel;
import com.vaadin.ui.components.grid.SingleSelectionModelImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridSelectionModeTest {
    private Grid<String> grid;

    @Before
    public void setup() {
        this.grid = new Grid();
        this.grid.setItems((Object[])new String[]{"foo", "bar", "baz"});
    }

    @Test
    public void testSelectionModes() {
        Assert.assertEquals(SingleSelectionModelImpl.class, this.grid.getSelectionModel().getClass());
        Assert.assertEquals(MultiSelectionModelImpl.class, this.grid.setSelectionMode(Grid.SelectionMode.MULTI).getClass());
        Assert.assertEquals(MultiSelectionModelImpl.class, this.grid.getSelectionModel().getClass());
        Assert.assertEquals(NoSelectionModel.class, this.grid.setSelectionMode(Grid.SelectionMode.NONE).getClass());
        Assert.assertEquals(NoSelectionModel.class, this.grid.getSelectionModel().getClass());
        Assert.assertEquals(SingleSelectionModelImpl.class, this.grid.setSelectionMode(Grid.SelectionMode.SINGLE).getClass());
        Assert.assertEquals(SingleSelectionModelImpl.class, this.grid.getSelectionModel().getClass());
    }

    @Test(expected=NullPointerException.class)
    public void testNullSelectionMode() {
        this.grid.setSelectionMode(null);
    }

    @Test
    public void testGridAsMultiSelectHasAllAPI() {
        this.assertAllAPIAvailable(GridMultiSelect.class, MultiSelectionModel.class, "asMultiSelect");
    }

    @Test
    public void testGridAsSingleSelectHasAllAPI() {
        this.assertAllAPIAvailable(GridSingleSelect.class, SingleSelectionModel.class, "asSingleSelect");
    }

    protected void assertAllAPIAvailable(Class<?> testedClass, Class<? extends SelectionModel> selectionModelClass, String ... ignoredMethods) {
        List<String> ignored = Arrays.asList(ignoredMethods);
        ArrayList missing = new ArrayList();
        Arrays.stream(selectionModelClass.getMethods()).filter(method -> {
            if (ignored.contains(method.getName())) {
                return false;
            }
            try {
                Extension.class.getMethod(method.getName(), method.getParameterTypes());
                return false;
            }
            catch (Exception e) {
                return true;
            }
        }).forEach(method -> {
            try {
                testedClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                missing.add(method);
            }
        });
        if (!missing.isEmpty()) {
            Assert.fail((String)("Methods " + missing.stream().map(Method::getName).collect(Collectors.joining(", ")) + " not found in " + testedClass.getSimpleName()));
        }
    }
}

