/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.MultiSelectionModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridMultiSelectionModelProxyItemTest {
    private List<String> data = IntStream.range(0, 100).boxed().map(i -> "String " + i).collect(Collectors.toList());
    private Grid<AtomicReference<String>> proxyGrid = new Grid();
    private MultiSelectionModel<AtomicReference<String>> model;
    private AtomicReference<Set<AtomicReference<String>>> selectionEvent = new AtomicReference();

    @Before
    public void setup() {
        this.proxyGrid.setDataProvider((DataProvider)new CallbackDataProvider((CallbackDataProvider.FetchCallback & Serializable)q -> this.data.stream().map(AtomicReference::new).skip(q.getOffset()).limit(q.getLimit()), (CallbackDataProvider.CountCallback & Serializable)q -> this.data.size(), AtomicReference::get));
        this.model = (MultiSelectionModel)this.proxyGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.model.addSelectionListener((SelectionListener & Serializable)e -> this.selectionEvent.set(e.getAllSelectedItems()));
    }

    @Test
    public void testSelectAllWithProxyDataProvider() {
        this.model.selectAll();
        Assert.assertEquals((String)"Item count mismatch on first select all", (long)100L, (long)this.getSelectionEvent().size());
        this.model.deselect((Object)((AtomicReference)this.model.getFirstSelectedItem().orElseThrow(() -> new IllegalStateException("Items should be selected"))));
        Assert.assertEquals((String)"Item count mismatch on deselect", (long)99L, (long)this.getSelectionEvent().size());
        this.model.selectAll();
        Assert.assertEquals((String)"Item count mismatch on second select all", (long)100L, (long)this.getSelectionEvent().size());
    }

    @Test
    public void testUpdateSelectionWithDuplicateEntries() {
        List selection = this.data.stream().filter(s -> s.contains("1")).collect(Collectors.toList());
        this.model.updateSelection(selection.stream().map(AtomicReference::new).collect(Collectors.toSet()), Collections.emptySet());
        Assert.assertEquals((String)"Failure in initial selection", (long)selection.size(), (long)this.getSelectionEvent().size());
        String toRemove = this.model.getFirstSelectedItem().map(AtomicReference::get).orElseThrow(() -> new IllegalStateException("Items should be selected"));
        this.model.updateSelection(Stream.of(toRemove).map(AtomicReference::new).collect(Collectors.toSet()), Stream.of(toRemove).map(AtomicReference::new).collect(Collectors.toSet()));
        Assert.assertNull((String)"Selection should not change when selecting and deselecting once", this.selectionEvent.get());
        LinkedHashSet<AtomicReference<String>> added = new LinkedHashSet<AtomicReference<String>>();
        LinkedHashSet<AtomicReference<String>> removed = new LinkedHashSet<AtomicReference<String>>();
        for (int i = 0; i < 20; ++i) {
            added.add(new AtomicReference<String>(toRemove));
            removed.add(new AtomicReference<String>(toRemove));
        }
        this.model.updateSelection(added, removed);
        Assert.assertNull((String)"Selection should not change when selecting and deselecting 20 times", this.selectionEvent.get());
        removed.add(new AtomicReference<String>(toRemove));
        this.model.updateSelection(added, removed);
        Assert.assertEquals((String)"Item should have been deselected", (long)(selection.size() - 1), (long)this.getSelectionEvent().size());
    }

    private Set<AtomicReference<String>> getSelectionEvent() {
        Optional<Set<AtomicReference<String>>> eventOptional = Optional.of(this.selectionEvent.get());
        this.selectionEvent.set(null);
        return eventOptional.orElseThrow(() -> new IllegalStateException("Expected selection event never happened"));
    }
}

