/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.shared.ui.grid.DropMode;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.GridDropTarget;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridDropTargetTest {
    private Grid<String> grid;
    private GridDropTarget<String> target;

    @Before
    public void setup() {
        this.grid = new Grid();
        this.grid.addColumn((ValueProvider & Serializable)s -> s).setId("1");
        this.grid.addColumn((ValueProvider & Serializable)s -> s).setId("2");
        this.target = new GridDropTarget(this.grid, DropMode.BETWEEN);
    }

    @Test
    public void dropAllowedOnSortedGridRows_defaultValue_isTrue() {
        Assert.assertTrue((String)"Default drop allowed should be backwards compatible", (boolean)this.target.isDropAllowedOnRowsWhenSorted());
    }

    @Test
    public void dropAllowedOnSortedGridRows_notAllowed_changesDropModeWhenSorted() {
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(false);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.sort("1");
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.grid.sort("2");
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.grid.clearSortOrder();
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.clearSortOrder();
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.sort("2");
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
    }

    @Test
    public void dropAllowedOnSortedGridRows_sortedGridIsDisallowed_modeChangesToOnGrid() {
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.sort("1");
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(false);
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(true);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
    }

    @Test
    public void dropAllowedOnSortedGridRows_notAllowedBackToAllowed_changesBackToUserDefinedMode() {
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(false);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.sort("1");
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(true);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.clearSortOrder();
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
    }

    @Test
    public void dropAllowedOnSortedGridRows_swappingAllowedDropOnSortedOffAndOn() {
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(false);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(false);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(true);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(true);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
    }

    @Test
    public void dropAllowedOnSortedGridRows_changingDropModeWhileSorted_replacesPreviouslyCachedButDoesntOverride() {
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(false);
        Assert.assertEquals((Object)DropMode.BETWEEN, (Object)this.target.getDropMode());
        this.grid.sort("1");
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.target.setDropMode(DropMode.ON_TOP);
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        Assert.assertFalse((String)"Changing drop mode should not have any effect here", (boolean)this.target.isDropAllowedOnRowsWhenSorted());
        this.grid.clearSortOrder();
        Assert.assertEquals((Object)DropMode.ON_TOP, (Object)this.target.getDropMode());
        this.grid.sort("1");
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.target.setDropMode(DropMode.ON_TOP_OR_BETWEEN);
        Assert.assertEquals((Object)DropMode.ON_GRID, (Object)this.target.getDropMode());
        this.target.setDropAllowedOnRowsWhenSorted(true);
        Assert.assertEquals((Object)DropMode.ON_TOP_OR_BETWEEN, (Object)this.target.getDropMode());
    }
}

