/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.GridSelectionModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GridDelegatesToSelectionModelTest {
    private GridSelectionModel<String> selectionModelMock;
    private CustomGrid grid;

    @Before
    public void init() {
        this.selectionModelMock = (GridSelectionModel)Mockito.mock(GridSelectionModel.class);
        this.grid = new CustomGrid();
    }

    @Test
    public void grid_getSelectedItems_delegated_to_SelectionModel() {
        this.grid.getSelectedItems();
        ((GridSelectionModel)Mockito.verify(this.selectionModelMock)).getSelectedItems();
    }

    @Test
    public void grid_select_delegated_to_SelectionModel() {
        this.grid.select("");
        ((GridSelectionModel)Mockito.verify(this.selectionModelMock)).select((Object)"");
    }

    @Test
    public void grid_deselect_delegated_to_SelectionModel() {
        this.grid.deselect("");
        ((GridSelectionModel)Mockito.verify(this.selectionModelMock)).deselect((Object)"");
    }

    @Test
    public void grid_deselectAll_delegated_to_SelectionModel() {
        this.grid.deselectAll();
        ((GridSelectionModel)Mockito.verify(this.selectionModelMock)).deselectAll();
    }

    private class CustomGrid
    extends Grid<String> {
        CustomGrid() {
            this.setSelectionModel(GridDelegatesToSelectionModelTest.this.selectionModelMock);
        }
    }
}

