/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridComponentRendererTest {
    private static final Person PERSON = Person.createTestPerson1();
    private Grid<Person> grid;
    private List<Person> backend;
    private DataProvider<Person, ?> dataProvider;
    private Label testComponent;
    private Label oldComponent;

    @Before
    public void setUp() {
        VaadinSession.setCurrent((VaadinSession)new AlwaysLockedVaadinSession(null));
        this.backend = new ArrayList<Person>();
        this.backend.add(PERSON);
        this.dataProvider = DataProvider.ofCollection(this.backend);
        this.grid = new Grid();
        this.grid.setDataProvider(this.dataProvider);
        this.grid.addComponentColumn((ValueProvider & Serializable)p -> {
            this.oldComponent = this.testComponent;
            this.testComponent = new Label();
            return this.testComponent;
        });
        new MockUI(){

            public Future<Void> access(Runnable runnable) {
                runnable.run();
                return null;
            }
        }.setContent((Component)this.grid);
    }

    @Test
    public void testComponentChangeOnRefresh() {
        this.generateDataForClient(true);
        this.dataProvider.refreshItem((Object)PERSON);
        this.generateDataForClient(false);
        Assert.assertNotNull((String)"Old component should exist.", (Object)this.oldComponent);
    }

    @Test
    public void testComponentChangeOnSelection() {
        this.generateDataForClient(true);
        this.grid.select((Object)PERSON);
        this.generateDataForClient(false);
        Assert.assertNotNull((String)"Old component should exist.", (Object)this.oldComponent);
    }

    @Test
    public void testComponentChangeOnDataProviderChange() {
        this.generateDataForClient(true);
        this.grid.setItems((Object[])new Person[]{PERSON});
        Assert.assertEquals((String)"Test component was not detached on DataProvider change.", null, (Object)this.testComponent.getParent());
    }

    private void generateDataForClient(boolean initial) {
        this.grid.getDataCommunicator().beforeClientResponse(initial);
        if (this.testComponent != null) {
            Assert.assertEquals((String)"New component was not attached.", this.grid, (Object)this.testComponent.getParent());
        }
        if (this.oldComponent != null) {
            Assert.assertEquals((String)"Old component was not detached.", null, (Object)this.oldComponent.getParent());
        }
    }
}

