/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.DefaultDeploymentConfiguration;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.MockServletConfig;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletResponse;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.ServletUIInitHandler;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ServletUIInitHandlerTest {
    @Test
    public void errorHandlerForInitException() throws Exception {
        final AtomicInteger pre = new AtomicInteger(0);
        AtomicInteger errorHandlerCalls = new AtomicInteger(0);
        UI ui = new UI(){

            protected void init(VaadinRequest request) {
                pre.incrementAndGet();
                throw new RuntimeException("Exception produced in init()");
            }
        };
        ui.setErrorHandler((ErrorHandler & Serializable)event -> errorHandlerCalls.incrementAndGet());
        CommunicationMock mock = new CommunicationMock(ui);
        VaadinRequest initRequest = mock.createInitRequest();
        ServletUIInitHandler servletUIInitHandler = new ServletUIInitHandler();
        servletUIInitHandler.handleRequest((VaadinSession)mock.session, initRequest, (VaadinResponse)new VaadinServletResponse((HttpServletResponse)Mockito.mock(HttpServletResponse.class), mock.service){

            public ServletOutputStream getOutputStream() throws IOException {
                return new ServletOutputStream(){

                    public void write(int b) throws IOException {
                    }
                };
            }
        });
        Assert.assertEquals((long)1L, (long)pre.getAndIncrement());
        Assert.assertEquals((long)1L, (long)errorHandlerCalls.getAndIncrement());
        Assert.assertEquals((Object)((Object)mock.session), (Object)ui.getSession());
    }

    @Test
    public void initExceptionNoErrorHandler() throws Exception {
        final AtomicInteger pre = new AtomicInteger(0);
        UI ui = new UI(){

            protected void init(VaadinRequest request) {
                pre.incrementAndGet();
                throw new RuntimeException("Exception produced in init()");
            }
        };
        CommunicationMock mock = new CommunicationMock(ui);
        VaadinRequest initRequest = mock.createInitRequest();
        ServletUIInitHandler servletUIInitHandler = new ServletUIInitHandler();
        servletUIInitHandler.handleRequest((VaadinSession)mock.session, initRequest, (VaadinResponse)new VaadinServletResponse((HttpServletResponse)Mockito.mock(HttpServletResponse.class), mock.service){

            public ServletOutputStream getOutputStream() throws IOException {
                return new ServletOutputStream(){

                    public void write(int b) throws IOException {
                    }
                };
            }
        });
        Assert.assertEquals((long)1L, (long)pre.getAndIncrement());
        Assert.assertEquals((Object)((Object)mock.session), (Object)ui.getSession());
    }

    public static class CommunicationMock {
        public final UI ui;
        public final ServletConfig servletConfig = new MockServletConfig();
        public final VaadinServlet servlet = new VaadinServlet();
        public final DefaultDeploymentConfiguration deploymentConfiguration;
        public final VaadinServletService service;
        public final AlwaysLockedVaadinSession session;

        public CommunicationMock(final UI ui) throws Exception {
            this.servlet.init(this.servletConfig);
            this.deploymentConfiguration = new DefaultDeploymentConfiguration(UI.class, new Properties());
            this.service = new VaadinServletService(this.servlet, (DeploymentConfiguration)this.deploymentConfiguration);
            this.session = new AlwaysLockedVaadinSession((VaadinService)this.service);
            LegacyCommunicationManager communicationManager = new LegacyCommunicationManager((VaadinSession)this.session);
            this.session.setCommunicationManager(communicationManager);
            this.session.setConfiguration((DeploymentConfiguration)this.deploymentConfiguration);
            AlwaysLockedVaadinSession.setCurrent((VaadinSession)this.session);
            this.session.addUIProvider(new UIProvider(){

                public Class<? extends UI> getUIClass(UIClassSelectionEvent event) {
                    return ui.getClass();
                }

                public UI createInstance(UICreateEvent event) {
                    return ui;
                }
            });
            this.ui = ui;
        }

        public VaadinRequest createInitRequest() {
            return new VaadinServletRequest((HttpServletRequest)Mockito.mock(HttpServletRequest.class), this.service){

                public String getMethod() {
                    return "POST";
                }

                public String getParameter(String name) {
                    if ("v-browserDetails".equals(name)) {
                        return "1";
                    }
                    return super.getParameter(name);
                }
            };
        }
    }
}

