/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.ServerRpcHandler;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.ui.UI;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ServerRpcHandlerTest {
    private VaadinRequest request;
    private VaadinService service;
    private AlwaysLockedVaadinSession session;
    private LegacyCommunicationManager communicationManager;
    private DeploymentConfiguration deploymentConfiguration;
    private UI ui;

    @Before
    public void setup() {
        this.request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        this.service = (VaadinService)Mockito.mock(VaadinService.class);
        this.session = new AlwaysLockedVaadinSession(this.service);
        this.communicationManager = (LegacyCommunicationManager)Mockito.mock(LegacyCommunicationManager.class);
        this.session.setCommunicationManager(this.communicationManager);
        Mockito.when((Object)this.request.getService()).thenReturn((Object)this.service);
        this.deploymentConfiguration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        this.ui = new TestUI();
        this.ui.doInit(this.request, 1, null);
        this.ui.setSession((VaadinSession)this.session);
        this.session.addUI(this.ui);
    }

    @Test
    public void handleUnknownConnector() {
        ServerRpcHandler handler = new ServerRpcHandler();
        JsonArray invocation = Json.createArray();
        invocation.set(0, "12");
        invocation.set(1, "someInterface");
        invocation.set(2, "someMethod");
        JsonArray params = Json.createArray();
        invocation.set(3, (JsonValue)params);
        JsonArray invocationData = Json.createArray();
        invocationData.set(0, (JsonValue)invocation);
        handler.handleInvocations(this.ui, 1, invocationData);
    }

    @Test
    public void handleRpc_duplicateMessage_doNotThrow() throws LegacyCommunicationManager.InvalidUIDLSecurityKeyException, IOException {
        String msg = "{\"clientId\":1}";
        ServerRpcHandler handler = new ServerRpcHandler();
        this.ui.setLastProcessedClientToServerId(1);
        handler.handleRpc(this.ui, msg, this.request);
        ((LegacyCommunicationManager)Mockito.verify((Object)this.communicationManager)).repaintAll(this.ui);
    }

    public static class TestUI
    extends UI {
        protected void init(VaadinRequest request) {
        }
    }
}

