/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.MockVaadinServletService;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionExpiredException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.PushHandler;
import com.vaadin.ui.UI;
import java.util.concurrent.Future;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PushHandlerTest {
    MockVaadinSession session = null;

    @Test
    public void connectionLost_currentInstancesAreCleared() throws SessionExpiredException, ServiceException {
        this.session = new MockVaadinSession(){

            public Future<Void> access(Runnable runnable) {
                runnable.run();
                return (Future)Mockito.mock(Future.class);
            }
        };
        VaadinSession.setCurrent((VaadinSession)this.session);
        Assert.assertNotNull((Object)VaadinSession.getCurrent());
        MockVaadinServletService service = null;
        service = new MockVaadinServletService(){

            public VaadinSession findVaadinSession(VaadinRequest request) throws SessionExpiredException {
                return PushHandlerTest.this.session;
            }

            public UI findUI(VaadinRequest request) {
                return null;
            }
        };
        service.init();
        PushHandler handler = new PushHandler((VaadinServletService)service);
        AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        AtmosphereRequest request = (AtmosphereRequest)Mockito.mock(AtmosphereRequest.class);
        Mockito.when((Object)resource.getRequest()).thenReturn((Object)request);
        AtmosphereResourceEvent event = (AtmosphereResourceEvent)Mockito.mock(AtmosphereResourceEvent.class);
        Mockito.when((Object)event.getResource()).thenReturn((Object)resource);
        handler.connectionLost(event);
        Assert.assertNull((Object)VaadinSession.getCurrent());
    }
}

