/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.SystemMessages;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedSession;
import com.vaadin.server.communication.MetadataWriter;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MetadataWriterTest {
    private UI ui;
    private VaadinSession session;
    private StringWriter writer;
    private SystemMessages messages;

    @Before
    public void setup() {
        this.ui = (UI)Mockito.mock(UI.class);
        this.session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)this.ui.getSession()).thenReturn((Object)this.session);
        this.writer = new StringWriter();
        this.messages = (SystemMessages)Mockito.mock(SystemMessages.class);
    }

    private void disableSessionExpirationMessages(SystemMessages messages) {
        Mockito.when((Object)messages.isSessionExpiredNotificationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)messages.getSessionExpiredMessage()).thenReturn(null);
        Mockito.when((Object)messages.getSessionExpiredCaption()).thenReturn(null);
    }

    @Test
    public void writeAsyncTag() throws Exception {
        new MetadataWriter().write(this.ui, (Writer)this.writer, false, true, this.messages);
        Assert.assertEquals((Object)"{\"async\":true}", (Object)this.writer.getBuffer().toString());
    }

    @Test
    public void writeRepaintTag() throws Exception {
        new MetadataWriter().write(this.ui, (Writer)this.writer, true, false, this.messages);
        Assert.assertEquals((Object)"{\"repaintAll\":true}", (Object)this.writer.getBuffer().toString());
    }

    @Test
    public void writeRepaintAndAsyncTag() throws Exception {
        new MetadataWriter().write(this.ui, (Writer)this.writer, true, true, this.messages);
        Assert.assertEquals((Object)"{\"repaintAll\":true, \"async\":true}", (Object)this.writer.getBuffer().toString());
    }

    @Test
    public void writeRedirectWithExpiredSession() throws Exception {
        this.disableSessionExpirationMessages(this.messages);
        new MetadataWriter().write(this.ui, (Writer)this.writer, false, false, this.messages);
        Assert.assertEquals((Object)"{}", (Object)this.writer.getBuffer().toString());
    }

    @Test
    public void writeRedirectWithActiveSession() throws Exception {
        WrappedSession wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)this.session.getSession()).thenReturn((Object)wrappedSession);
        this.disableSessionExpirationMessages(this.messages);
        new MetadataWriter().write(this.ui, (Writer)this.writer, false, false, this.messages);
        Assert.assertEquals((Object)"{\"timedRedirect\":{\"interval\":15,\"url\":\"\"}}", (Object)this.writer.getBuffer().toString());
    }

    @Test
    public void writeAsyncWithSystemMessages() throws IOException {
        WrappedSession wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)this.session.getSession()).thenReturn((Object)wrappedSession);
        this.disableSessionExpirationMessages(this.messages);
        new MetadataWriter().write(this.ui, (Writer)this.writer, false, true, this.messages);
        Assert.assertEquals((Object)"{\"async\":true,\"timedRedirect\":{\"interval\":15,\"url\":\"\"}}", (Object)this.writer.getBuffer().toString());
    }
}

