/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.communication.AtmospherePushConnection;
import com.vaadin.server.communication.LongPollingCacheFilter;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class LongPollingCacheFilterTest {
    static final String RESOURCE_UUID = "resourceUUID";
    LongPollingCacheFilter filter = new LongPollingCacheFilter();
    AtmospherePushConnection.PushMessage originalMessage = new AtmospherePushConnection.PushMessage(5, "PUSH ME");
    Object nonPushMessage = new Object();
    Object message = new Object();
    private AtmosphereResource resource;
    private BroadcasterCache cache;

    @Test
    public void filter_notPushMessage_continueWithCurrentMessage() {
        this.setTransport(AtmosphereResource.TRANSPORT.LONG_POLLING);
        this.setSeenServerSyncIdHeader(5, new int[0]);
        BroadcastFilter.BroadcastAction action = this.filter.filter("broadcasterId", this.resource, this.nonPushMessage, this.message);
        Assert.assertEquals((Object)BroadcastFilter.BroadcastAction.ACTION.CONTINUE, (Object)action.action());
        Assert.assertSame((String)"Message should not be altered by filter", (Object)this.message, (Object)action.message());
        this.verifyMessageIsNotCached();
    }

    @Test
    public void filter_notLongPollingTransport_continueWithCurrentMessage() {
        this.setSeenServerSyncIdHeader(5, new int[0]);
        Stream.of(AtmosphereResource.TRANSPORT.values()).filter(t -> t != AtmosphereResource.TRANSPORT.LONG_POLLING).forEach(transport -> {
            this.setTransport((AtmosphereResource.TRANSPORT)transport);
            BroadcastFilter.BroadcastAction action = this.filter.filter("broadcasterId", this.resource, (Object)this.originalMessage, this.message);
            Assert.assertEquals((Object)BroadcastFilter.BroadcastAction.ACTION.CONTINUE, (Object)action.action());
            Assert.assertSame((String)("Message should not be altered by filter when transport is " + transport), (Object)this.message, (Object)action.message());
        });
        this.verifyMessageIsNotCached();
    }

    @Test
    public void filter_syncIdCheckDisabled_continueWithCurrentMessage() {
        this.setTransport(AtmosphereResource.TRANSPORT.LONG_POLLING);
        this.setSeenServerSyncIdHeader(-1, new int[0]);
        BroadcastFilter.BroadcastAction action = this.filter.filter("broadcasterId", this.resource, (Object)this.originalMessage, this.message);
        Assert.assertEquals((Object)BroadcastFilter.BroadcastAction.ACTION.CONTINUE, (Object)action.action());
        Assert.assertSame((String)"Message should not be altered by filter if syncId check is disabled", (Object)this.message, (Object)action.message());
        this.verifyMessageIsNotCached();
    }

    @Test
    public void filter_missingLastSeenServerSyncId_continueWithCurrentMessage() {
        this.setTransport(AtmosphereResource.TRANSPORT.LONG_POLLING);
        BroadcastFilter.BroadcastAction action = this.filter.filter("broadcasterId", this.resource, (Object)this.originalMessage, this.message);
        Assert.assertEquals((Object)BroadcastFilter.BroadcastAction.ACTION.CONTINUE, (Object)action.action());
        Assert.assertSame((String)"Message should not be altered by filter if server sync id header is missing", (Object)this.message, (Object)action.message());
        this.verifyMessageIsNotCached();
    }

    @Test
    public void filter_messageAlreadySeen_abort() {
        this.setTransport(AtmosphereResource.TRANSPORT.LONG_POLLING);
        this.setSeenServerSyncIdHeader(5, 6);
        BroadcastFilter.BroadcastAction action = this.filter.filter("broadcasterId", this.resource, (Object)this.originalMessage, this.message);
        Assert.assertEquals((String)"Expecting message seen on client to be skipped", (Object)BroadcastFilter.BroadcastAction.ACTION.ABORT, (Object)action.action());
        Assert.assertSame((String)"Message should not be altered by filter when aborting", (Object)this.message, (Object)action.message());
        action = this.filter.filter("broadcasterId", this.resource, (Object)this.originalMessage, this.message);
        Assert.assertEquals((String)"Expecting message seen on client to be skipped", (Object)BroadcastFilter.BroadcastAction.ACTION.ABORT, (Object)action.action());
        Assert.assertSame((String)"Message should not be altered by filter when aborting", (Object)this.message, (Object)action.message());
        this.verifyMessageIsNotCached();
    }

    @Test
    public void filter_messageNotYetSeen_addToCacheAndContinue() {
        this.setTransport(AtmosphereResource.TRANSPORT.LONG_POLLING);
        this.setSeenServerSyncIdHeader(2, new int[0]);
        String broadcasterId = "broadcasterId";
        BroadcastFilter.BroadcastAction action = this.filter.filter(broadcasterId, this.resource, (Object)this.originalMessage, this.message);
        Assert.assertEquals((String)"Expecting message not seen on client to be sent", (Object)BroadcastFilter.BroadcastAction.ACTION.CONTINUE, (Object)action.action());
        Assert.assertSame((String)"Message should not be altered by filter when continuing", (Object)this.message, (Object)action.message());
        ((BroadcasterCache)Mockito.verify((Object)this.cache)).addToCache((String)Matchers.eq((Object)broadcasterId), (String)Matchers.eq((Object)RESOURCE_UUID), (BroadcastMessage)Matchers.argThat((Matcher)new ArgumentMatcher<BroadcastMessage>(){

            public boolean matches(Object m) {
                if (m instanceof BroadcastMessage) {
                    return ((BroadcastMessage)m).message() == LongPollingCacheFilterTest.this.originalMessage;
                }
                return false;
            }
        }));
    }

    @Before
    public void setUp() {
        this.resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        AtmosphereRequest request = (AtmosphereRequest)Mockito.mock(AtmosphereRequest.class);
        Broadcaster broadcaster = (Broadcaster)Mockito.mock(Broadcaster.class);
        BroadcasterConfig broadcasterConfig = (BroadcasterConfig)Mockito.mock(BroadcasterConfig.class);
        this.cache = (BroadcasterCache)Mockito.mock(BroadcasterCache.class);
        Mockito.when((Object)broadcaster.getBroadcasterConfig()).thenReturn((Object)broadcasterConfig);
        Mockito.when((Object)broadcasterConfig.getBroadcasterCache()).thenReturn((Object)this.cache);
        Mockito.when((Object)this.resource.getBroadcaster()).thenReturn((Object)broadcaster);
        Mockito.when((Object)this.resource.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.resource.uuid()).thenReturn((Object)RESOURCE_UUID);
    }

    private void setTransport(AtmosphereResource.TRANSPORT transport) {
        Mockito.when((Object)this.resource.transport()).thenReturn((Object)transport);
    }

    private void setSeenServerSyncIdHeader(int id, int ... ids) {
        Mockito.when((Object)this.resource.getRequest().getHeader("X-Vaadin-LastSeenServerSyncId")).thenReturn((Object)Integer.toString(id), (Object[])((String[])IntStream.of(ids).mapToObj(Integer::toString).toArray(String[]::new)));
    }

    private void verifyMessageIsNotCached() {
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.cache});
    }
}

