/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.StreamVariable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.FileUploadHandler;
import com.vaadin.ui.ConnectorTracker;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HugeFileUploadTest {
    private static final String SEC_KEY = "4";
    private static final String CONN_ID = "2";
    private static final int UI_ID = 1;
    @Mock
    private VaadinSession session;
    @Mock
    private VaadinResponse response;
    @Mock
    private VaadinRequest request;
    @Mock
    private UI ui;
    @Mock
    private StreamVariable streamVariable;
    @Mock
    private ConnectorTracker connectorTracker;

    @Before
    public void setup() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/APP/UPLOAD/1/2/var/4");
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)"application/multipart-attached;boundary=bbbbb");
        Mockito.when((Object)this.session.hasLock()).thenReturn((Object)true);
        Mockito.when((Object)this.session.getUIById(1)).thenReturn((Object)this.ui);
        Mockito.when((Object)this.ui.getConnectorTracker()).thenReturn((Object)this.connectorTracker);
        Mockito.when((Object)this.connectorTracker.getStreamVariable(CONN_ID, "var")).thenReturn((Object)this.streamVariable);
        Mockito.when((Object)this.connectorTracker.getSeckey(this.streamVariable)).thenReturn((Object)SEC_KEY);
        Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)new InputStream(){

            @Override
            public int read() throws IOException {
                return 97;
            }
        });
    }

    @Test(expected=IOException.class, timeout=60000L)
    public void testHugeFileWithoutNewLine() throws IOException {
        FileUploadHandler fileUploadHandler = new FileUploadHandler();
        fileUploadHandler.handleRequest(this.session, this.request, this.response);
    }
}

