/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.StreamVariable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.FileUploadHandler;
import com.vaadin.ui.ConnectorTracker;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class FileUploadHandlerTest {
    private FileUploadHandler handler;
    @Mock
    private VaadinResponse response;
    @Mock
    private StreamVariable streamVariable;
    @Mock
    private ClientConnector clientConnector;
    @Mock
    private VaadinRequest request;
    @Mock
    private UI ui;
    @Mock
    private ConnectorTracker connectorTracker;
    @Mock
    private VaadinSession session;
    @Mock
    private OutputStream responseOutput;
    private final int uiId = 123;
    private final String connectorId = "connectorId";
    private final String variableName = "name";
    private final String expectedSecurityKey = "key";

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.handler = new FileUploadHandler();
        this.mockRequest();
        this.mockConnectorTracker();
        this.mockUi();
        Mockito.when((Object)this.clientConnector.isConnectorEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.streamVariable.getOutputStream()).thenReturn((Object)((OutputStream)Mockito.mock(OutputStream.class)));
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.responseOutput);
    }

    private void mockConnectorTracker() {
        Mockito.when((Object)this.connectorTracker.getSeckey(this.streamVariable)).thenReturn((Object)"key");
        Mockito.when((Object)this.connectorTracker.getStreamVariable("connectorId", "name")).thenReturn((Object)this.streamVariable);
        Mockito.when((Object)this.connectorTracker.getConnector("connectorId")).thenReturn((Object)this.clientConnector);
    }

    private void mockRequest() throws IOException {
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/APP/UPLOAD/123/connectorId/name/key");
        Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)this.createInputStream("foobar"));
        Mockito.when((Object)this.request.getHeader("Content-Length")).thenReturn((Object)"6");
        Mockito.when((Object)this.request.getContentType()).thenReturn((Object)"foobar");
    }

    private InputStream createInputStream(final String content) {
        return new InputStream(){
            int counter = 0;
            byte[] msg = content.getBytes();

            @Override
            public int read() throws IOException {
                if (this.counter > this.msg.length + 1) {
                    throw new AssertionError((Object)"-1 was ignored by FileUploadHandler.");
                }
                if (this.counter >= this.msg.length) {
                    ++this.counter;
                    return -1;
                }
                return this.msg[this.counter++];
            }
        };
    }

    private void mockUi() {
        Mockito.when((Object)this.ui.getConnectorTracker()).thenReturn((Object)this.connectorTracker);
        Mockito.when((Object)this.session.getUIById(123)).thenReturn((Object)this.ui);
    }

    @Test(expected=IOException.class)
    public void exceptionIsThrownOnUnexpectedEnd() throws IOException {
        Mockito.when((Object)this.request.getInputStream()).thenReturn((Object)this.createInputStream(""));
        Mockito.when((Object)this.request.getHeader("Content-Length")).thenReturn((Object)"1");
        this.handler.doHandleSimpleMultipartFileUpload(null, this.request, null, null, null, null, null);
    }

    @Test
    public void responseIsSentOnCorrectSecurityKey() throws IOException {
        Mockito.when((Object)this.connectorTracker.getSeckey(this.streamVariable)).thenReturn((Object)"key");
        this.handler.handleRequest(this.session, this.request, this.response);
        ((OutputStream)Mockito.verify((Object)this.responseOutput)).close();
    }

    @Test
    public void responseIsNotSentOnIncorrectSecurityKey() throws IOException {
        Mockito.when((Object)this.connectorTracker.getSeckey(this.streamVariable)).thenReturn((Object)"another key expected");
        this.handler.handleRequest(this.session, this.request, this.response);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.responseOutput});
    }

    @Test
    public void responseIsNotSentOnMissingSecurityKey() throws IOException {
        Mockito.when((Object)this.connectorTracker.getSeckey(this.streamVariable)).thenReturn(null);
        this.handler.handleRequest(this.session, this.request, this.response);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.responseOutput});
    }
}

