/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server.communication;

import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.AtmospherePushConnection;
import com.vaadin.ui.ConnectorTracker;
import com.vaadin.ui.UI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AtmospherePushConnectionTest {
    @Test
    public void testSerialization() throws Exception {
        UI ui = (UI)EasyMock.createNiceMock(UI.class);
        AtmosphereResource resource = (AtmosphereResource)EasyMock.createNiceMock(AtmosphereResource.class);
        AtmospherePushConnection connection = new AtmospherePushConnection(ui);
        connection.connect(resource);
        Assert.assertEquals((Object)AtmospherePushConnection.State.CONNECTED, (Object)connection.getState());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(connection);
        connection = (AtmospherePushConnection)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assert.assertEquals((Object)AtmospherePushConnection.State.DISCONNECTED, (Object)connection.getState());
    }

    @Test
    public void pushWhileDisconnect_disconnectedWithoutSendingMessage() throws Exception {
        UI ui = (UI)Mockito.spy((Object)new UI(){

            protected void init(VaadinRequest request) {
            }
        });
        ConnectorTracker tracker = (ConnectorTracker)Mockito.mock(ConnectorTracker.class);
        Mockito.when((Object)ui.getConnectorTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)tracker.getDirtyVisibleConnectors()).thenReturn(new ArrayList());
        MockVaadinSession vaadinSession = new MockVaadinSession();
        Mockito.when((Object)ui.getSession()).thenReturn((Object)vaadinSession);
        Broadcaster broadcaster = (Broadcaster)Mockito.mock(Broadcaster.class);
        AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        Mockito.when((Object)resource.getBroadcaster()).thenReturn((Object)broadcaster);
        AtmospherePushConnection connection = new AtmospherePushConnection(ui);
        connection.connect(resource);
        CountDownLatch latch = new CountDownLatch(1);
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            vaadinSession.lock();
            try {
                connection.push();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                vaadinSession.unlock();
                latch.countDown();
            }
        });
        connection.disconnect();
        Assert.assertTrue((String)"AtmospherePushConnection not disconnected", (boolean)latch.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((Object)AtmospherePushConnection.State.PUSH_PENDING, (Object)connection.getState());
        Mockito.verifyZeroInteractions((Object[])new Object[]{broadcaster});
    }

    @Test
    public void disconnectWhilePush_messageSentAndThenDisconnected() throws Exception {
        UI ui = (UI)Mockito.spy((Object)new UI(){

            protected void init(VaadinRequest request) {
            }
        });
        ConnectorTracker tracker = (ConnectorTracker)Mockito.mock(ConnectorTracker.class);
        Mockito.when((Object)ui.getConnectorTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)tracker.getDirtyVisibleConnectors()).thenReturn(new ArrayList());
        MockVaadinSession vaadinSession = new MockVaadinSession();
        Mockito.when((Object)ui.getSession()).thenReturn((Object)vaadinSession);
        Broadcaster broadcaster = (Broadcaster)Mockito.mock(Broadcaster.class);
        AtmosphereResource resource = (AtmosphereResource)Mockito.mock(AtmosphereResource.class);
        Mockito.when((Object)resource.getBroadcaster()).thenReturn((Object)broadcaster);
        AtmospherePushConnection connection = new AtmospherePushConnection(ui);
        connection.connect(resource);
        CountDownLatch latch = new CountDownLatch(1);
        CompletableFuture.runAsync(() -> {
            vaadinSession.lock();
            try {
                vaadinSession.setCommunicationManager(new LegacyCommunicationManager((VaadinSession)vaadinSession));
                CompletableFuture.runAsync(() -> ((AtmospherePushConnection)connection).disconnect());
                connection.push();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
            finally {
                vaadinSession.unlock();
                latch.countDown();
            }
        });
        Assert.assertTrue((String)"Push not completed", (boolean)latch.await(2L, TimeUnit.SECONDS));
        ((Broadcaster)Mockito.verify((Object)broadcaster)).broadcast(Matchers.any(Object.class), (AtmosphereResource)Matchers.eq((Object)resource));
    }
}

