/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.DefaultUIProvider;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.MockServletConfig;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.Page;
import com.vaadin.server.ServiceException;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedHttpSession;
import com.vaadin.server.WrappedSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VaadinSessionTest
implements Serializable {
    private transient VaadinSession session;
    private transient VaadinServlet mockServlet;
    private transient VaadinServletService mockService;
    private transient ServletConfig mockServletConfig;
    private transient HttpSession mockHttpSession;
    private transient WrappedSession mockWrappedSession;
    private transient VaadinServletRequest vaadinRequest;
    private transient UI ui;
    private transient Lock httpSessionLock;

    @Before
    public void setup() throws Exception {
        this.httpSessionLock = new ReentrantLock();
        this.mockServletConfig = new MockServletConfig();
        this.mockServlet = new VaadinServlet();
        this.mockServlet.init(this.mockServletConfig);
        this.mockService = this.mockServlet.getService();
        this.mockHttpSession = (HttpSession)EasyMock.createMock(HttpSession.class);
        this.mockWrappedSession = new WrappedHttpSession(this.mockHttpSession){
            final ReentrantLock lock;
            {
                this.lock = new ReentrantLock();
                this.lock.lock();
            }

            public Object getAttribute(String name) {
                Object res;
                try {
                    Thread.sleep(100L);
                    Assert.assertTrue((String)"Deadlock detected", (boolean)VaadinSessionTest.this.httpSessionLock.tryLock(5L, TimeUnit.SECONDS));
                    String lockAttribute = VaadinSessionTest.this.mockService.getServiceName() + ".lock";
                    res = lockAttribute.equals(name) ? this.lock : ("com.vaadin.server.VaadinSession.Mock Servlet".equals(name) ? VaadinSessionTest.this.session : super.getAttribute(name));
                    VaadinSessionTest.this.httpSessionLock.unlock();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return res;
            }
        };
        IMocksControl control = EasyMock.createNiceControl();
        DeploymentConfiguration dc = (DeploymentConfiguration)control.createMock(DeploymentConfiguration.class);
        this.session = new VaadinSession((VaadinService)this.mockService);
        this.mockService.storeSession(this.session, this.mockWrappedSession);
        this.ui = new MockPageUI();
        HttpServletRequest request = (HttpServletRequest)control.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getParameter("v-loc")).andReturn((Object)"http://localhost/");
        control.replay();
        this.vaadinRequest = new VaadinServletRequest(request, this.mockService){

            public String getParameter(String name) {
                if ("theme".equals(name) || "restartApplication".equals(name) || "ignoreRestart".equals(name) || "closeApplication".equals(name)) {
                    return null;
                }
                if ("v-browserDetails".equals(name)) {
                    return "1";
                }
                return super.getParameter(name);
            }

            public Object getAttribute(String name) {
                if (name.equals("com.vaadin.server.UI_ROOT_PATH")) {
                    return "/";
                }
                return super.getAttribute(name);
            }

            public String getMethod() {
                return "POST";
            }

            public WrappedSession getWrappedSession(boolean allowSessionCreation) {
                return VaadinSessionTest.this.mockWrappedSession;
            }
        };
        this.session.setConfiguration(dc);
        this.ui.setSession(this.session);
        this.ui.doInit((VaadinRequest)this.vaadinRequest, this.session.getNextUIid(), null);
        this.session.addUI(this.ui);
    }

    @Test
    public void testInvalidationDeadlock() {
        new Thread(() -> {
            try {
                Thread.sleep(150L);
                this.httpSessionLock.lock();
                try {
                    this.mockService.fireSessionDestroy(this.session);
                }
                finally {
                    this.httpSessionLock.unlock();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }).start();
        try {
            this.mockService.findVaadinSession((VaadinRequest)this.vaadinRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentInstancePollution() throws InterruptedException {
        AtomicInteger state = new AtomicInteger();
        Runnable napper = () -> {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        };
        this.session.unlock();
        try {
            Thread thread = new Thread(() -> this.session.accessSynchronously(() -> {
                state.incrementAndGet();
                while (state.get() == 1) {
                    napper.run();
                }
            }));
            thread.start();
            while (state.get() == 0) {
                napper.run();
            }
            this.session.access(() -> {
                UI.setCurrent((UI)this.ui);
                state.incrementAndGet();
            });
            AtomicReference uiRef = new AtomicReference();
            this.session.access(() -> {
                uiRef.set(UI.getCurrent());
                state.incrementAndGet();
            });
            state.incrementAndGet();
            while (state.get() < 4) {
                napper.run();
            }
            Assert.assertNull(uiRef.get());
        }
        finally {
            this.session.lock();
        }
    }

    @Test
    public void threadLocalsAfterUnderlyingSessionTimeout() throws InterruptedException {
        AtomicBoolean detachCalled = new AtomicBoolean(false);
        this.ui.addDetachListener((ClientConnector.DetachListener & Serializable)event -> {
            detachCalled.set(true);
            Assert.assertEquals((Object)this.ui, (Object)UI.getCurrent());
            Assert.assertEquals((Object)this.ui.getPage(), (Object)Page.getCurrent());
            Assert.assertEquals((Object)this.session, (Object)VaadinSession.getCurrent());
            Assert.assertEquals((Object)this.mockService, (Object)VaadinService.getCurrent());
            Assert.assertEquals((Object)this.mockServlet, (Object)VaadinServlet.getCurrent());
        });
        this.session.valueUnbound((HttpSessionBindingEvent)EasyMock.createMock(HttpSessionBindingEvent.class));
        this.mockService.runPendingAccessTasks(this.session);
        Assert.assertTrue((boolean)detachCalled.get());
    }

    @Test
    public void threadLocalsAfterSessionDestroy() throws InterruptedException {
        AtomicBoolean detachCalled = new AtomicBoolean(false);
        this.ui.addDetachListener((ClientConnector.DetachListener & Serializable)event -> {
            detachCalled.set(true);
            Assert.assertEquals((Object)this.ui, (Object)UI.getCurrent());
            Assert.assertEquals((Object)this.ui.getPage(), (Object)Page.getCurrent());
            Assert.assertEquals((Object)this.session, (Object)VaadinSession.getCurrent());
            Assert.assertEquals((Object)this.mockService, (Object)VaadinService.getCurrent());
            Assert.assertEquals((Object)this.mockServlet, (Object)VaadinServlet.getCurrent());
        });
        CurrentInstance.clearAll();
        this.session.close();
        this.mockService.cleanupSession(this.session);
        this.mockService.runPendingAccessTasks(this.session);
        Assert.assertTrue((boolean)detachCalled.get());
    }

    @Test
    public void testValueUnbound() {
        MockVaadinSession vaadinSession = new MockVaadinSession((VaadinService)this.mockService);
        vaadinSession.valueUnbound((HttpSessionBindingEvent)EasyMock.createMock(HttpSessionBindingEvent.class));
        Assert.assertEquals((String)"'valueUnbound' method doesn't call 'close' for the session", (long)1L, (long)vaadinSession.getCloseCount());
        vaadinSession.valueUnbound((HttpSessionBindingEvent)EasyMock.createMock(HttpSessionBindingEvent.class));
        Assert.assertEquals((String)"'valueUnbound' method may not call 'close' method for closing session", (long)1L, (long)vaadinSession.getCloseCount());
    }

    @Test
    public void threadLocalsWhenDeserializing() throws Exception {
        VaadinSession.setCurrent((VaadinSession)this.session);
        this.session.lock();
        SerializationTestLabel label = new SerializationTestLabel();
        Assert.assertEquals((String)"Session should be set when instance is created", (Object)this.session, (Object)label.session);
        this.ui.setContent((Component)label);
        int uiId = this.ui.getUIId();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(this.session);
        }
        this.session.unlock();
        CurrentInstance.clearAll();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        VaadinSession deserializedSession = (VaadinSession)in.readObject();
        Assert.assertNull((String)"Current session shouldn't leak from deserialisation", (Object)VaadinSession.getCurrent());
        Assert.assertNotSame((String)"Should get a new session", (Object)this.session, (Object)deserializedSession);
        deserializedSession.refreshTransients(this.mockWrappedSession, (VaadinService)this.mockService);
        deserializedSession.lock();
        UI deserializedUi = deserializedSession.getUIById(uiId);
        SerializationTestLabel deserializedLabel = (SerializationTestLabel)deserializedUi.getContent();
        Assert.assertEquals((String)"Current session should be available in SerializationTestLabel.readObject", (Object)deserializedSession, (Object)deserializedLabel.session);
        deserializedSession.unlock();
    }

    @Test
    public void lockedDuringSerialization() throws IOException {
        final AtomicBoolean lockChecked = new AtomicBoolean(false);
        this.ui.setContent((Component)new Label(){

            private void writeObject(ObjectOutputStream out) throws IOException {
                Assert.assertTrue((boolean)VaadinSessionTest.this.session.hasLock());
                lockChecked.set(true);
                out.defaultWriteObject();
            }
        });
        this.session.unlock();
        Assert.assertFalse((boolean)this.session.hasLock());
        ObjectOutputStream out = new ObjectOutputStream(new ByteArrayOutputStream());
        out.writeObject(this.session);
        Assert.assertFalse((boolean)this.session.hasLock());
        Assert.assertTrue((boolean)lockChecked.get());
    }

    @Test
    public void uiProviderOrderingAndStability() {
        DefaultUIProvider[] testProviders = new DefaultUIProvider[]{new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider()};
        ArrayList<DefaultUIProvider> expectedProviderList = new ArrayList<DefaultUIProvider>();
        expectedProviderList.addAll(this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[0]);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(0, testProviders[0]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[1], -1);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(testProviders[1]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[2], -1);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(expectedProviderList.size() - 1, testProviders[2]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[3], 1);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(0, testProviders[3]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[4], 1);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(0, testProviders[4]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[5], 1);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(0, testProviders[5]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.removeUIProvider((UIProvider)testProviders[4]);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.remove(testProviders[4]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[4], 1);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(0, testProviders[4]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        Assert.assertEquals((long)-1L, (long)this.session.getUIProviderPriority((UIProvider)testProviders[1]));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)this.session.getUIProviderPriority((UIProvider)testProviders[6]));
        this.session.addUIProvider((UIProvider)testProviders[6]);
        Assert.assertNotEquals(expectedProviderList, (Object)this.session.getUIProviders());
        expectedProviderList.add(3, testProviders[6]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
    }

    @Test
    public void uiProviderReordering() {
        DefaultUIProvider[] testProviders = new DefaultUIProvider[]{new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider(), new DefaultUIProvider()};
        ArrayList<DefaultUIProvider> expectedProviderList = new ArrayList<DefaultUIProvider>();
        expectedProviderList.addAll(this.session.getUIProviders());
        this.session.addUIProvider((UIProvider)testProviders[0]);
        this.session.addUIProvider((UIProvider)testProviders[1]);
        this.session.addUIProvider((UIProvider)testProviders[2]);
        this.session.addUIProvider((UIProvider)testProviders[3]);
        expectedProviderList.add(0, testProviders[0]);
        expectedProviderList.add(0, testProviders[1]);
        expectedProviderList.add(0, testProviders[2]);
        expectedProviderList.add(0, testProviders[3]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
        this.session.setUIProviderPriority((UIProvider)testProviders[2], 1);
        this.session.setUIProviderPriority((UIProvider)testProviders[3], -1);
        expectedProviderList.remove(testProviders[2]);
        expectedProviderList.remove(testProviders[3]);
        expectedProviderList.add(0, testProviders[2]);
        expectedProviderList.add(testProviders[3]);
        Assert.assertEquals(expectedProviderList, (Object)this.session.getUIProviders());
    }

    @Test
    public void csrfToken_different_sessions_shouldBeUnique() throws Exception {
        String token1 = this.session.getCsrfToken();
        this.setup();
        String token2 = this.session.getCsrfToken();
        Assert.assertNotEquals((String)"Each session should have a unique CSRF token", (Object)token1, (Object)token2);
    }

    @Test
    public void csrfToken_same_session_shouldBeSame() {
        String token1 = this.session.getCsrfToken();
        String token2 = this.session.getCsrfToken();
        Assert.assertEquals((String)"getCsrfToken() should always return the same value for the same session", (Object)token1, (Object)token2);
    }

    @Test
    public void valueUnbound_explicitVaadinSessionClose_wrappedSessionIsNotCleanedUp() throws ServiceException {
        this.session.setAttribute(VaadinSession.CLOSE_SESSION_EXPLICITLY, (Object)true);
        VaadinSession.setCurrent((VaadinSession)this.session);
        this.mockService.setCurrentInstances((VaadinRequest)EasyMock.createMock(VaadinRequest.class), (VaadinResponse)EasyMock.createMock(VaadinResponse.class));
        Assert.assertEquals((Object)VaadinSession.State.OPEN, (Object)this.session.getState());
        try {
            this.session.valueUnbound((HttpSessionBindingEvent)EasyMock.createMock(HttpSessionBindingEvent.class));
            Assert.assertNotEquals((String)"Session didn't get unbound properly", (Object)VaadinSession.State.OPEN, (Object)this.session.getState());
            Assert.assertNotNull((String)"Wrapped session got cleaned up when it shouldn't have", (Object)this.session.getSession());
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void valueUnbound_implicitVaadinSessionClose_wrappedSessionIsCleanedUp() throws ServiceException {
        VaadinSession.setCurrent((VaadinSession)this.session);
        this.mockService.setCurrentInstances((VaadinRequest)EasyMock.createMock(VaadinRequest.class), (VaadinResponse)EasyMock.createMock(VaadinResponse.class));
        Assert.assertEquals((Object)VaadinSession.State.OPEN, (Object)this.session.getState());
        try {
            this.session.valueUnbound((HttpSessionBindingEvent)EasyMock.createMock(HttpSessionBindingEvent.class));
            Assert.assertNotEquals((String)"Session didn't get unbound properly", (Object)VaadinSession.State.OPEN, (Object)this.session.getState());
            Assert.assertNull((String)"Wrapped session not cleaned up when it should have", (Object)this.session.getSession());
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    @Test
    public void setState_closedState_sessionFieldIsCleanedUp() throws ServiceException {
        Assert.assertNotNull((Object)this.session.getSession());
        Assert.assertEquals((Object)VaadinSession.State.OPEN, (Object)this.session.getState());
        this.session.setState(VaadinSession.State.CLOSING);
        this.session.setState(VaadinSession.State.CLOSED);
        Assert.assertNull((String)"Updating the state to closed didn't clean up the session,", (Object)this.session.getSession());
    }

    private static class SerializationTestLabel
    extends Label {
        private transient VaadinSession session = VaadinSession.getCurrent();

        private SerializationTestLabel() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.session = VaadinSession.getCurrent();
        }
    }

    private static class MockPageUI
    extends UI {
        Page page;

        private MockPageUI() {
            this.page = new Page(this, this.getState((boolean)false).pageState){};
        }

        protected void init(VaadinRequest request) {
        }

        public Page getPage() {
            return this.page;
        }
    }
}

