/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.MockServletConfig;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.WarURLStreamHandlerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class VaadinServletTest {
    @After
    public void tearDown() {
        Assert.assertNull((Object)VaadinService.getCurrent());
    }

    @Test
    public void testGetLastPathParameter() {
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com"));
        Assert.assertEquals((Object)";a", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com;a"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello"));
        Assert.assertEquals((Object)";b=c", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello;b=c"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello;a/"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello;a=1/"));
        Assert.assertEquals((Object)";b", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b"));
        Assert.assertEquals((Object)";b=1", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b=1"));
        Assert.assertEquals((Object)";b=1,c=2", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b=1,c=2"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/hello/;b=1,c=2/"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;a/"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;a=1/"));
        Assert.assertEquals((Object)";b", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b"));
        Assert.assertEquals((Object)";b=1", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b=1"));
        Assert.assertEquals((Object)";b=1,c=2", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b=1,c=2"));
        Assert.assertEquals((Object)"", (Object)VaadinServlet.getLastPathParameter((String)"http://myhost.com/a;hello/;b=1,c=2/"));
    }

    @Test
    public void getStaticFilePath() {
        VaadinServlet servlet = new VaadinServlet();
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("/VAADIN", null)));
        Assert.assertEquals((Object)"/VAADIN/", (Object)servlet.getStaticFilePath(this.createServletRequest("/VAADIN", "/")));
        Assert.assertEquals((Object)"/VAADIN/vaadinBootstrap.js", (Object)servlet.getStaticFilePath(this.createServletRequest("/VAADIN", "/vaadinBootstrap.js")));
        Assert.assertEquals((Object)"/VAADIN/foo bar.js", (Object)servlet.getStaticFilePath(this.createServletRequest("/VAADIN", "/foo bar.js")));
        Assert.assertEquals((Object)"/VAADIN/..", (Object)servlet.getStaticFilePath(this.createServletRequest("/VAADIN", "/..")));
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("", null)));
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("", "/VAADIN")));
        Assert.assertEquals((Object)"/VAADIN/", (Object)servlet.getStaticFilePath(this.createServletRequest("", "/VAADIN/")));
        Assert.assertEquals((Object)"/VAADIN/foo bar.js", (Object)servlet.getStaticFilePath(this.createServletRequest("", "/VAADIN/foo bar.js")));
        Assert.assertEquals((Object)"/VAADIN/..", (Object)servlet.getStaticFilePath(this.createServletRequest("", "/VAADIN/..")));
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("", "/BAADIN/foo.js")));
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("/myservlet", null)));
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("/myservlet", "/VAADIN")));
        Assert.assertEquals((Object)"/VAADIN/", (Object)servlet.getStaticFilePath(this.createServletRequest("/myservlet", "/VAADIN/")));
        Assert.assertEquals((Object)"/VAADIN/foo bar.js", (Object)servlet.getStaticFilePath(this.createServletRequest("/myservlet", "/VAADIN/foo bar.js")));
        Assert.assertEquals((Object)"/VAADIN/..", (Object)servlet.getStaticFilePath(this.createServletRequest("/myservlet", "/VAADIN/..")));
        Assert.assertNull((Object)servlet.getStaticFilePath(this.createServletRequest("/myservlet", "/BAADIN/foo.js")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void directoryIsNotResourceRequest() throws Exception {
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)new MockServletConfig());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        TemporaryFolder folder = TemporaryFolder.builder().build();
        folder.create();
        try {
            File vaadinFolder = folder.newFolder("VAADIN");
            vaadinFolder.createNewFile();
            String rootAbsolutePath = folder.getRoot().getAbsolutePath().replaceAll("\\\\", "/");
            if (rootAbsolutePath.endsWith("/")) {
                rootAbsolutePath = rootAbsolutePath.substring(0, rootAbsolutePath.length() - 1);
            }
            URL folderPath = new URL("file:///" + rootAbsolutePath);
            Assert.assertFalse((String)"Folder on disk should not be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, folderPath));
            Assert.assertFalse((String)"Fake should not check the file system nor be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("file:///fake/")));
            File archiveFile = this.createJAR(folder);
            Path tempArchive = archiveFile.toPath();
            String tempArchivePath = tempArchive.toString().replaceAll("\\\\", "/");
            Assert.assertFalse((String)"Folder 'VAADIN' in jar should not be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("jar:file:///" + tempArchivePath + "!/VAADIN")));
            Assert.assertFalse((String)"File 'file.txt' inside jar should not be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("jar:file:///" + tempArchivePath + "!/file.txt")));
            Assert.assertTrue((String)"File 'file.txt' inside VAADIN folder within jar should be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("jar:file:///" + tempArchivePath + "!/VAADIN/file.txt")));
            Assert.assertFalse((String)"Directory 'folder' inside VAADIN folder within jar should not be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("jar:file:///" + tempArchivePath + "!/VAADIN/folder")));
            Assert.assertFalse((String)"File 'file.txt' outside of a jar should not be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("file:///" + rootAbsolutePath + "/file.txt")));
            Assert.assertTrue((String)"File 'file.txt' inside VAADIN folder outside of a jar should be an allowed resource.", (boolean)servlet.isAllowedVAADINResourceUrl(request, new URL("file:///" + rootAbsolutePath + "/VAADIN/file.txt")));
        }
        finally {
            folder.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isAllowedVAADINResource_jarWarFileScheme_detectsAsStaticResources() throws IOException, URISyntaxException, ServletException {
        Assert.assertTrue((String)"Can not run concurrently with other test", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.isEmpty());
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)new MockServletConfig());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        TemporaryFolder folder = TemporaryFolder.builder().build();
        folder.create();
        try {
            File archiveFile = this.createJAR(folder);
            File warFile = this.createWAR(folder, archiveFile);
            WarURLStreamHandlerFactory.getInstance();
            URL folderResourceURL = new URL("jar:war:" + warFile.toURI().toURL() + "!/" + archiveFile.getName() + "!/VAADIN/folder");
            Assert.assertTrue((String)"Should be evaluated as a static request because we cannot determine non-file resources within jar files.", (boolean)servlet.isAllowedVAADINResourceUrl(request, folderResourceURL));
            URL fileResourceURL = new URL("jar:war:" + warFile.toURI().toURL() + "!/" + archiveFile.getName() + "!/VAADIN/file.txt");
            Assert.assertTrue((String)"Should be evaluated as a static request.", (boolean)servlet.isAllowedVAADINResourceUrl(request, fileResourceURL));
        }
        finally {
            folder.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isAllowedVAADINResource_jarInAJar_detectsAsStaticResources() throws IOException, URISyntaxException, ServletException {
        Assert.assertTrue((String)"Can not run concurrently with other test", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.isEmpty());
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)new MockServletConfig());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        TemporaryFolder folder = TemporaryFolder.builder().build();
        folder.create();
        try {
            File archiveFile = this.createJAR(folder);
            File warFile = this.createWAR(folder, archiveFile);
            URL folderResourceURL = new URL("jar:" + warFile.toURI().toURL() + "!/" + archiveFile.getName() + "!/VAADIN/folder");
            Assert.assertTrue((String)"Should be evaluated as a static request because we cannot determine non-file resources within jar files.", (boolean)servlet.isAllowedVAADINResourceUrl(request, folderResourceURL));
            URL fileResourceURL = new URL("jar:" + warFile.toURI().toURL() + "!/" + archiveFile.getName() + "!/VAADIN/file.txt");
            Assert.assertTrue((String)"Should be evaluated as a static request.", (boolean)servlet.isAllowedVAADINResourceUrl(request, fileResourceURL));
            URL fileNonStaticResourceURL = new URL("jar:" + warFile.toURI().toURL() + "!/" + archiveFile.getName() + "!/file.txt");
            Assert.assertFalse((String)"Should not be evaluated as a static request even within a jar because it's not within 'VAADIN' folder.", (boolean)servlet.isAllowedVAADINResourceUrl(request, fileNonStaticResourceURL));
        }
        finally {
            folder.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openFileServerExistsForZip_openingNewDoesNotFail() throws IOException, URISyntaxException {
        Assert.assertTrue((String)"Can not run concurrently with other test", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.isEmpty());
        VaadinServlet servlet = new VaadinServlet();
        TemporaryFolder folder = TemporaryFolder.builder().build();
        folder.create();
        try {
            Path tempArchive = this.createJAR(folder).toPath();
            FileSystem fileSystem = FileSystems.newFileSystem(new URL("jar:file:///" + tempArchive.toString().replaceAll("\\\\", "/") + "!/").toURI(), Collections.emptyMap());
            URL folderResourceURL = new URL("jar:file:///" + tempArchive.toString().replaceAll("\\\\", "/") + "!/VAADIN");
            try {
                servlet.getFileSystem(folderResourceURL.toURI());
            }
            finally {
                servlet.closeFileSystem(folderResourceURL.toURI());
                fileSystem.close();
            }
        }
        finally {
            folder.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openingJarFileSystemForDifferentFilesInSameJar_existingFileSystemIsUsed() throws IOException, URISyntaxException, ServletException {
        Assert.assertTrue((String)"Can not run concurrently with other test", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.isEmpty());
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)new MockServletConfig());
        TemporaryFolder folder = TemporaryFolder.builder().build();
        folder.create();
        try {
            File archiveFile = this.createJAR(folder);
            String tempArchivePath = archiveFile.toPath().toString().replaceAll("\\\\", "/");
            URL folderResourceURL = new URL("jar:file:///" + tempArchivePath + "!/VAADIN");
            URL fileResourceURL = new URL("jar:file:///" + tempArchivePath + "!/file.txt");
            servlet.getFileSystem(folderResourceURL.toURI());
            servlet.getFileSystem(fileResourceURL.toURI());
            Assert.assertEquals((String)"Same file should be marked for both resources", (Object)2, VaadinServlet.OPEN_FILE_SYSTEMS.entrySet().iterator().next().getValue());
            servlet.closeFileSystem(folderResourceURL.toURI());
            Assert.assertEquals((String)"Closing resource should be removed from jar uri", (Object)1, VaadinServlet.OPEN_FILE_SYSTEMS.entrySet().iterator().next().getValue());
            servlet.closeFileSystem(fileResourceURL.toURI());
            Assert.assertTrue((String)"Closing last resource should clear marking", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.isEmpty());
            try {
                FileSystems.getFileSystem(folderResourceURL.toURI());
                Assert.fail((String)"Jar FileSystem should have been closed");
            }
            catch (FileSystemNotFoundException fileSystemNotFoundException) {
                // empty catch block
            }
        }
        finally {
            folder.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentRequestsToJarResources_checksAreCorrect() throws IOException, InterruptedException, ExecutionException, URISyntaxException, ServletException {
        Assert.assertTrue((String)"Can not run concurrently with other test", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.isEmpty());
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)new MockServletConfig());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        TemporaryFolder folder = TemporaryFolder.builder().build();
        folder.create();
        try {
            File archiveFile = this.createJAR(folder);
            String tempArchivePath = archiveFile.toPath().toString().replaceAll("\\\\", "/");
            URL fileNotResourceURL = new URL("jar:file:///" + tempArchivePath + "!/file.txt");
            String fileNotResourceErrorMessage = "File file.text outside folder 'VAADIN' in jar should not be a static resource.";
            this.checkAllowedVAADINResourceConcurrently(servlet, request, fileNotResourceURL, fileNotResourceErrorMessage, false);
            this.ensureFileSystemsCleared(fileNotResourceURL);
            URL folderNotResourceURL = new URL("jar:file:///" + tempArchivePath + "!/VAADIN");
            String folderNotResourceErrorMessage = "Folder 'VAADIN' in jar should not be a static resource.";
            this.checkAllowedVAADINResourceConcurrently(servlet, request, folderNotResourceURL, folderNotResourceErrorMessage, false);
            this.ensureFileSystemsCleared(folderNotResourceURL);
            URL fileIsResourceURL = new URL("jar:file:///" + tempArchivePath + "!/VAADIN/file.txt");
            String fileIsResourceErrorMessage = "File 'file.txt' inside VAADIN folder within jar should be a static resource.";
            this.checkAllowedVAADINResourceConcurrently(servlet, request, fileIsResourceURL, fileIsResourceErrorMessage, true);
            this.ensureFileSystemsCleared(fileIsResourceURL);
        }
        finally {
            folder.delete();
        }
    }

    private HttpServletRequest createServletRequest(String servletPath, String pathInfo) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)servletPath);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)("/context" + pathInfo));
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/context");
        return request;
    }

    private File createJAR(TemporaryFolder folder) throws IOException {
        File archiveFile = new File(folder.getRoot(), "fake.jar");
        archiveFile.createNewFile();
        Path tempArchive = archiveFile.toPath();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempArchive, new OpenOption[0]));){
            zipOutputStream.putNextEntry(new ZipEntry("/file.txt"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("VAADIN/"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("VAADIN/file.txt"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("VAADIN/folder/"));
            zipOutputStream.closeEntry();
        }
        return archiveFile;
    }

    private File createWAR(TemporaryFolder folder, File archiveFile) throws IOException {
        Path tempArchive = archiveFile.toPath();
        File warFile = new File(folder.getRoot(), "fake.war");
        warFile.createNewFile();
        Path warArchive = warFile.toPath();
        try (ZipOutputStream warOutputStream = new ZipOutputStream(Files.newOutputStream(warArchive, new OpenOption[0]));){
            warOutputStream.putNextEntry(new ZipEntry(archiveFile.getName()));
            warOutputStream.write(Files.readAllBytes(tempArchive));
            warOutputStream.closeEntry();
        }
        return warFile;
    }

    private void checkAllowedVAADINResourceConcurrently(VaadinServlet servlet, HttpServletRequest request, URL resourceURL, String resourceErrorMessage, boolean expected) throws InterruptedException, ExecutionException {
        int THREADS = 5;
        List fileNotResource = IntStream.range(0, THREADS).mapToObj(i -> {
            Callable<Result> callable = () -> {
                try {
                    if (expected != servlet.isAllowedVAADINResourceUrl(request, resourceURL)) {
                        throw new IllegalArgumentException(resourceErrorMessage);
                    }
                }
                catch (Exception e) {
                    return new Result(e);
                }
                return new Result(null);
            };
            return callable;
        }).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(THREADS);
        List futures = executor.invokeAll(fileNotResource);
        ArrayList<String> exceptions = new ArrayList<String>();
        executor.shutdown();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.exception == null) continue;
            exceptions.add(result.exception.getMessage());
        }
        Assert.assertTrue((String)("There were exceptions in concurrent calls {" + exceptions + "}"), (boolean)exceptions.isEmpty());
    }

    private void ensureFileSystemsCleared(URL fileResourceURL) throws URISyntaxException {
        Assert.assertFalse((String)"URI should have been cleared", (boolean)VaadinServlet.OPEN_FILE_SYSTEMS.containsKey(fileResourceURL.toURI()));
        try {
            FileSystems.getFileSystem(fileResourceURL.toURI());
            Assert.fail((String)"FileSystem for file resource should be closed");
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
    }

    private static class Result {
        final Exception exception;

        Result(Exception exception) {
            this.exception = exception;
        }
    }
}

