/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Widgetset;
import com.vaadin.server.UIProvider;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.Assert;
import org.junit.Test;

public class UIProviderTest {
    @Test
    public void getAnnotationFor_widgetsetAnnotationForSubclass_annotationFound() {
        Assert.assertNotNull((String)"Widgetset annotation is not found for subclass", (Object)UIProvider.getAnnotationFor(TestClass.class, Widgetset.class));
    }

    @Test
    public void getAnnotationFor_themeAnnotationForSubclass_annotationFound() {
        Assert.assertNotNull((String)"Theme annotation is not found for subclass", (Object)UIProvider.getAnnotationFor(TestClass.class, Theme.class));
    }

    @Test
    public void getAnnotationFor_themeAnnotationForSubclass_annotationOverridden() {
        Assert.assertEquals((String)"Theme annotation is not overridden correctly in subclass", (Object)"c", (Object)((Theme)UIProvider.getAnnotationFor(TestClass.class, Theme.class)).value());
    }

    @Test
    public void getAnnotationFor_notInheritedAnnotationForSubclass_annotationFound() {
        Assert.assertNotNull((String)"TestAnnotation annotation is not found for subclass", (Object)UIProvider.getAnnotationFor(TestClass.class, TestAnnotation.class));
    }

    @Test
    public void getAnnotationFor_directAnnotationForSubclass_annotationFound() {
        Assert.assertNotNull((String)"TestAnnotation1 annotation is not found for subclass", (Object)UIProvider.getAnnotationFor(TestClass.class, TestAnnotation1.class));
    }

    @Test
    public void getAnnotationFor_annotationInheritedFromInterface_annotationFound() {
        Assert.assertNotNull((String)"Theme annotation is not inherited from interface", (Object)UIProvider.getAnnotationFor(ClassImplementingInterface.class, Theme.class));
    }

    public static class ClassImplementingInterface
    implements InterfaceWithAnnotation {
    }

    @Theme(value="d")
    public static interface InterfaceWithAnnotation {
    }

    @TestAnnotation1
    @Theme(value="c")
    public static class TestClass
    extends TestSuperClass {
    }

    @Widgetset(value="a")
    @Theme(value="b")
    @TestAnnotation
    public static class TestSuperClass {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TestAnnotation1 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TestAnnotation {
    }
}

