/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.MockServletConfig;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbstractApplicationServletStaticFilesLocation {
    VaadinServlet servlet;

    @Before
    public void setUp() throws Exception {
        this.servlet = new VaadinServlet();
        this.servlet.init((ServletConfig)new MockServletConfig());
    }

    @Test
    public void testWidgetSetLocation() throws Exception {
        String location = this.testLocation("http://dummy.host:8080", "/contextpath", "/servlet", "");
        Assert.assertEquals((Object)".", (Object)location);
        location = this.testLocation("http://dummy.host:8080", "/contextpath", "/servlet", "/");
        Assert.assertEquals((Object)"./..", (Object)location);
        location = this.testLocation("http://dummy.host:8080", "", "/servlet", "");
        Assert.assertEquals((Object)".", (Object)location);
        location = this.testLocation("http://dummy.host", "/contextpath", "/servlet", "/extra/stuff");
        Assert.assertEquals((Object)"./../..", (Object)location);
        location = this.testLocation("http://dummy.host", "/context/path", "/servlet", "/extra/stuff");
        Assert.assertEquals((Object)"./../..", (Object)location);
    }

    private String testLocation(String base, String contextPath, String servletPath, String pathInfo) throws Exception {
        HttpServletRequest request = this.createNonIncludeRequest(base, contextPath, servletPath, pathInfo);
        EasyMock.replay((Object[])new Object[]{request});
        String location = this.servlet.getService().getStaticFileLocation((VaadinRequest)this.servlet.createVaadinRequest(request));
        return location;
    }

    private HttpServletRequest createNonIncludeRequest(String base, String realContextPath, String realServletPath, String pathInfo) throws Exception {
        HttpServletRequest request = this.createRequest(base, realContextPath, realServletPath, pathInfo);
        EasyMock.expect((Object)request.getAttribute("javax.servlet.include.context_path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)request.getAttribute("javax.servlet.include.servlet_path")).andReturn(null).anyTimes();
        return request;
    }

    private HttpServletRequest createRequest(String base, String contextPath, String servletPath, String pathInfo) throws MalformedURLException {
        URL url = new URL(base + contextPath + pathInfo);
        HttpServletRequest request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.isSecure()).andReturn((Object)url.getProtocol().equalsIgnoreCase("https")).anyTimes();
        EasyMock.expect((Object)request.getServerName()).andReturn((Object)url.getHost()).anyTimes();
        EasyMock.expect((Object)request.getServerPort()).andReturn((Object)url.getPort()).anyTimes();
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)url.getPath()).anyTimes();
        EasyMock.expect((Object)request.getContextPath()).andReturn((Object)contextPath).anyTimes();
        EasyMock.expect((Object)request.getPathInfo()).andReturn((Object)pathInfo).anyTimes();
        EasyMock.expect((Object)request.getServletPath()).andReturn((Object)servletPath).anyTimes();
        return request;
    }
}

