/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.JsonPaintTarget;
import com.vaadin.server.LegacyCommunicationManager;
import com.vaadin.server.Page;
import com.vaadin.server.PaintException;
import com.vaadin.server.PaintTarget;
import com.vaadin.shared.ui.ui.PageState;
import com.vaadin.ui.UI;
import java.io.Writer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class PageTest {
    @Test
    public void removeBrowserWindowResizeListener_listenerIsAttached_listenerRemoved() {
        Page page = new Page((UI)EasyMock.createMock(UI.class), (PageState)EasyMock.createMock(PageState.class));
        TestBrowserWindowResizeListener listener = new TestBrowserWindowResizeListener();
        page.addBrowserWindowResizeListener((Page.BrowserWindowResizeListener)listener);
        page.removeBrowserWindowResizeListener((Page.BrowserWindowResizeListener)listener);
        page.updateBrowserWindowSize(0, 0, true);
        Assert.assertFalse((String)"Listener is called after removal", (boolean)listener.isCalled());
    }

    @Test
    public void removeBrowserWindowResizeListener_listenerIsNotAttached_stateIsUpdated() {
        TestPage page = new TestPage((UI)EasyMock.createMock(UI.class), (PageState)EasyMock.createMock(PageState.class));
        Page.BrowserWindowResizeListener listener = (Page.BrowserWindowResizeListener)EasyMock.createMock(Page.BrowserWindowResizeListener.class);
        page.removeBrowserWindowResizeListener(listener);
        Assert.assertFalse((String)"Page state 'hasResizeListeners' property has wrong value", (boolean)page.getState((boolean)false).hasResizeListeners);
    }

    @Test
    public void cssStringInjectedTwice() throws PaintException {
        TestPage page = new TestPage((UI)EasyMock.createMock(UI.class), (PageState)EasyMock.createMock(PageState.class));
        JsonPaintTarget paintTarget = new JsonPaintTarget((LegacyCommunicationManager)EasyMock.createMock(LegacyCommunicationManager.class), (Writer)EasyMock.createMock(Writer.class), true);
        page.getStyles().add(".my-style { color: red; }");
        Assert.assertEquals((long)page.getStyles().pendingInjections.size(), (long)1L);
        page.paintContent((PaintTarget)paintTarget);
        Assert.assertEquals((long)page.getStyles().pendingInjections.size(), (long)0L);
        Assert.assertEquals((long)page.getStyles().injectedStyles.size(), (long)1L);
        page.getStyles().add(".my-style { color: red; }");
        Assert.assertEquals((long)page.getStyles().pendingInjections.size(), (long)0L);
        page.paintContent((PaintTarget)paintTarget);
        Assert.assertEquals((long)page.getStyles().pendingInjections.size(), (long)0L);
        Assert.assertEquals((long)page.getStyles().injectedStyles.size(), (long)1L);
    }

    private static class TestBrowserWindowResizeListener
    implements Page.BrowserWindowResizeListener {
        private boolean isCalled;

        private TestBrowserWindowResizeListener() {
        }

        public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
            this.isCalled = true;
        }

        public boolean isCalled() {
            return this.isCalled;
        }
    }

    private static class TestPage
    extends Page {
        public TestPage(UI uI, PageState state) {
            super(uI, state);
        }

        protected PageState getState(boolean markAsDirty) {
            return super.getState(markAsDirty);
        }
    }
}

