/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.JsonCodec;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;

public class JsonEqualsTest {
    @Test
    public void differentTypes_notEqual() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((double)5.0), (JsonValue)Json.create((String)"5"));
        Assert.assertFalse((String)"Different types should not be equal", (boolean)equals);
    }

    @Test
    public void nulls_equal() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.createNull(), (JsonValue)Json.createNull());
        Assert.assertTrue((String)"Null and null should be equal", (boolean)equals);
    }

    @Test
    public void differentBooleans_notEqual() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((boolean)true), (JsonValue)Json.create((boolean)false));
        Assert.assertFalse((String)"Different booleans should not be equal", (boolean)equals);
    }

    @Test
    public void sameBooleans_equal() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((boolean)false), (JsonValue)Json.create((boolean)false));
        Assert.assertTrue((String)"Same booleans should be equal", (boolean)equals);
    }

    @Test
    public void differentNumbers_notEqual() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((double)2.0), (JsonValue)Json.create((double)5.6));
        Assert.assertFalse((String)"Different numbers should not be equal", (boolean)equals);
    }

    @Test
    public void sameNumbers_equal() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((double)3.14), (JsonValue)Json.create((double)3.14));
        Assert.assertTrue((String)"Same numbers should be equal", (boolean)equals);
    }

    @Test
    public void differentStrings_notEqual() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((String)"abc"), (JsonValue)Json.create((String)"def"));
        Assert.assertFalse((String)"Different strings should not be equal", (boolean)equals);
    }

    @Test
    public void sameStrings_equal() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)Json.create((String)"abc"), (JsonValue)Json.create((String)"abc"));
        Assert.assertTrue((String)"Same strings should be equal", (boolean)equals);
    }

    @Test
    public void differentKeyCountObject_notEqual() {
        JsonObject o1 = Json.createObject();
        o1.put("key", "value");
        JsonObject o2 = Json.createObject();
        boolean equals = JsonCodec.jsonEquals((JsonValue)o1, (JsonValue)o2);
        Assert.assertFalse((String)"Object with different key counts should not be equal", (boolean)equals);
    }

    @Test
    public void differentKeySetObject_notEqual() {
        JsonObject o1 = Json.createObject();
        o1.put("key", "value");
        JsonObject o2 = Json.createObject();
        o2.put("key2", "value");
        boolean equals = JsonCodec.jsonEquals((JsonValue)o1, (JsonValue)o2);
        Assert.assertFalse((String)"Object with different keys should not be equal", (boolean)equals);
    }

    @Test
    public void differentChildValuesObject_notEqual() {
        JsonObject o1 = Json.createObject();
        o1.put("key", "value");
        JsonObject o2 = Json.createObject();
        o2.put("key", true);
        boolean equals = JsonCodec.jsonEquals((JsonValue)o1, (JsonValue)o2);
        Assert.assertFalse((String)"Object with different child values should not be equal", (boolean)equals);
    }

    @Test
    public void emptyObjects_equal() {
        JsonObject o1 = Json.createObject();
        JsonObject o2 = Json.createObject();
        boolean equals = JsonCodec.jsonEquals((JsonValue)o1, (JsonValue)o2);
        Assert.assertTrue((String)"Empty objects should be equal", (boolean)equals);
    }

    @Test
    public void sameObjects_equal() {
        JsonObject o1 = Json.createObject();
        o1.put("key", "value");
        JsonObject o2 = Json.createObject();
        o2.put("key", "value");
        boolean equals = JsonCodec.jsonEquals((JsonValue)o1, (JsonValue)o2);
        Assert.assertTrue((String)"Same objects should be equal", (boolean)equals);
    }

    @Test
    public void sameObjectsWithNullValues_equal() {
        JsonObject o1 = Json.createObject();
        o1.put("key", (JsonValue)Json.createNull());
        JsonObject o2 = Json.createObject();
        o2.put("key", (JsonValue)Json.createNull());
        boolean equals = JsonCodec.jsonEquals((JsonValue)o1, (JsonValue)o2);
        Assert.assertTrue((String)"Same objects should be equal", (boolean)equals);
    }

    @Test
    public void differentSizeArray_notEqual() {
        JsonArray a1 = Json.createArray();
        a1.set(0, 0.0);
        JsonArray a2 = Json.createArray();
        boolean equals = JsonCodec.jsonEquals((JsonValue)a1, (JsonValue)a2);
        Assert.assertFalse((String)"Arrays with different sizes should not be equal", (boolean)equals);
    }

    @Test
    public void differentContentArray_notEqual() {
        JsonArray a1 = Json.createArray();
        a1.set(0, 0.0);
        JsonArray a2 = Json.createArray();
        a2.set(0, 1.0);
        boolean equals = JsonCodec.jsonEquals((JsonValue)a1, (JsonValue)a2);
        Assert.assertFalse((String)"Arrays with different content should not be equal", (boolean)equals);
    }

    @Test
    public void differentOrderArray_notEqual() {
        JsonArray a1 = Json.createArray();
        a1.set(0, 0.0);
        a1.set(1, true);
        JsonArray a2 = Json.createArray();
        a2.set(0, true);
        a2.set(1, 0.0);
        boolean equals = JsonCodec.jsonEquals((JsonValue)a1, (JsonValue)a2);
        Assert.assertFalse((String)"Arrays with different order should not be equal", (boolean)equals);
    }

    @Test
    public void emptyArrays_equal() {
        JsonArray a1 = Json.createArray();
        JsonArray a2 = Json.createArray();
        boolean equals = JsonCodec.jsonEquals((JsonValue)a1, (JsonValue)a2);
        Assert.assertTrue((String)"Empty arrays should be equal", (boolean)equals);
    }

    @Test
    public void sameArrays_equal() {
        JsonArray a1 = Json.createArray();
        a1.set(0, 0.0);
        a1.set(1, true);
        JsonArray a2 = Json.createArray();
        a2.set(0, 0.0);
        a2.set(1, true);
        boolean equals = JsonCodec.jsonEquals((JsonValue)a1, (JsonValue)a2);
        Assert.assertTrue((String)"Same arrays should be equal", (boolean)equals);
    }

    @Test
    public void sameArraysWitNull_equal() {
        JsonArray a1 = Json.createArray();
        a1.set(0, (JsonValue)Json.createNull());
        JsonArray a2 = Json.createArray();
        a2.set(0, (JsonValue)Json.createNull());
        boolean equals = JsonCodec.jsonEquals((JsonValue)a1, (JsonValue)a2);
        Assert.assertTrue((String)"Same arrays should be equal", (boolean)equals);
    }

    @Test
    public void differentDeeplyNested_notEquals() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)JsonEqualsTest.createDeeplyNestedValue(1), (JsonValue)JsonEqualsTest.createDeeplyNestedValue(2));
        Assert.assertFalse((String)"Values should not be equal", (boolean)equals);
    }

    @Test
    public void sameDeeplyNested_equals() {
        boolean equals = JsonCodec.jsonEquals((JsonValue)JsonEqualsTest.createDeeplyNestedValue(1), (JsonValue)JsonEqualsTest.createDeeplyNestedValue(1));
        Assert.assertTrue((String)"Values should be equal", (boolean)equals);
    }

    private static JsonValue createDeeplyNestedValue(int leafValue) {
        JsonObject childObject = Json.createObject();
        childObject.put("value", (double)leafValue);
        JsonArray childArray = Json.createArray();
        childArray.set(0, (JsonValue)childObject);
        JsonObject value = Json.createObject();
        value.put("child", (JsonValue)childArray);
        return value;
    }
}

