/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.JsonCodec;
import com.vaadin.shared.communication.UidlValue;
import com.vaadin.shared.ui.splitpanel.AbstractSplitPanelState;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonException;
import elemental.json.JsonValue;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JSONSerializerTest {
    Map<String, AbstractSplitPanelState> stringToStateMap;
    Map<AbstractSplitPanelState, String> stateToStringMap;

    @Test
    public void testStringToBeanMapSerialization() throws Exception {
        Type mapType = this.getClass().getDeclaredField("stringToStateMap").getGenericType();
        this.stringToStateMap = new HashMap<String, AbstractSplitPanelState>();
        AbstractSplitPanelState s = new AbstractSplitPanelState();
        AbstractSplitPanelState s2 = new AbstractSplitPanelState();
        s.caption = "State 1";
        s.id = "foo";
        s2.caption = "State 2";
        s2.id = "bar";
        this.stringToStateMap.put("string - state 1", s);
        this.stringToStateMap.put("String - state 2", s2);
        JsonValue encodedMap = JsonCodec.encode(this.stringToStateMap, null, (Type)mapType, null).getEncodedValue();
        this.ensureDecodedCorrectly(this.stringToStateMap, encodedMap, mapType);
    }

    @Test
    public void testBeanToStringMapSerialization() throws Exception {
        Type mapType = this.getClass().getDeclaredField("stateToStringMap").getGenericType();
        this.stateToStringMap = new HashMap<AbstractSplitPanelState, String>();
        AbstractSplitPanelState s = new AbstractSplitPanelState();
        AbstractSplitPanelState s2 = new AbstractSplitPanelState();
        s.caption = "State 1";
        s2.caption = "State 2";
        this.stateToStringMap.put(s, "string - state 1");
        this.stateToStringMap.put(s2, "String - state 2");
        JsonValue encodedMap = JsonCodec.encode(this.stateToStringMap, null, (Type)mapType, null).getEncodedValue();
        this.ensureDecodedCorrectly(this.stateToStringMap, encodedMap, mapType);
    }

    @Test
    public void testNullLegacyValue() throws JsonException {
        JsonArray inputArray = Json.createArray();
        inputArray.set(0, "n");
        inputArray.set(1, (JsonValue)Json.createNull());
        UidlValue decodedObject = (UidlValue)JsonCodec.decodeInternalType(UidlValue.class, (boolean)true, (JsonValue)inputArray, null);
        Assert.assertNull((Object)decodedObject.getValue());
    }

    @Test(expected=JsonException.class)
    public void testNullTypeOtherValue() {
        JsonArray inputArray = Json.createArray();
        inputArray.set(0, "n");
        inputArray.set(1, "a");
        UidlValue decodedObject = (UidlValue)JsonCodec.decodeInternalType(UidlValue.class, (boolean)true, (JsonValue)inputArray, null);
    }

    private void ensureDecodedCorrectly(Object original, JsonValue encoded, Type type) throws Exception {
        Object serverSideDecoded = JsonCodec.decodeInternalOrCustomType((Type)type, (JsonValue)encoded, null);
        Assert.assertTrue((String)"Server decoded", (boolean)this.equals(original, serverSideDecoded));
    }

    private boolean equals(Object o1, Object o2) throws Exception {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Map) {
            if (!(o2 instanceof Map)) {
                return false;
            }
            return this.equalsMap((Map)o1, (Map)o2);
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (o1 instanceof Collection || o1 instanceof Number || o1 instanceof String) {
            return o1.equals(o2);
        }
        return this.equalsBean(o1, o2);
    }

    private boolean equalsBean(Object o1, Object o2) throws Exception {
        for (JsonCodec.BeanProperty property : JsonCodec.getProperties(o1.getClass())) {
            Object c2;
            Object c1 = property.getValue(o1);
            if (this.equals(c1, c2 = property.getValue(o2))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsMap(Map o1, Map o2) throws Exception {
        for (Object key1 : o1.keySet()) {
            Object key2 = key1;
            if (!o2.containsKey(key2)) {
                for (Object k2 : o2.keySet()) {
                    if (!this.equals(key1, k2)) continue;
                    key2 = k2;
                    break;
                }
            }
            if (this.equals(o1.get(key1), o2.get(key2))) continue;
            return false;
        }
        return true;
    }
}

