/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.DownloadStream;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class DownloadStreamTest {
    private String filename = "A \u00e5\u65e5.png";
    private String encodedFileName = "A%20%c3%a5%e6%97%a5.png";
    private DownloadStream stream;

    @Before
    public void setup() {
        this.stream = new DownloadStream((InputStream)Mockito.mock(InputStream.class), "", this.filename);
    }

    @Test
    public void contentDispositionFilenameIsUtf8Encoded() throws IOException {
        VaadinResponse response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.stream.writeResponse((VaadinRequest)Mockito.mock(VaadinRequest.class), response);
        ((VaadinResponse)Mockito.verify((Object)response)).setHeader((String)Matchers.eq((Object)"Content-Disposition"), Matchers.contains((String)String.format("filename=\"%s\";", this.encodedFileName)));
        ((VaadinResponse)Mockito.verify((Object)response)).setHeader((String)Matchers.eq((Object)"Content-Disposition"), Matchers.contains((String)String.format("filename*=utf-8''%s", this.encodedFileName)));
    }
}

