/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.JsonCodec;
import com.vaadin.server.communication.JSONSerializer;
import com.vaadin.ui.ConnectorTracker;
import elemental.json.JsonValue;
import java.lang.reflect.Type;
import org.junit.Assert;
import org.junit.Test;

public class CustomJSONSerializerTest {
    @Test
    public void testMultipleRegistration() {
        boolean thrown = false;
        try {
            JsonCodec.setCustomSerializer(Foo.class, (JSONSerializer)new FooSerializer());
            JsonCodec.setCustomSerializer(Foo.class, (JSONSerializer)new FooSerializer());
        }
        catch (IllegalStateException ise) {
            thrown = true;
        }
        finally {
            JsonCodec.setCustomSerializer(Foo.class, null);
        }
        Assert.assertTrue((String)"Multiple serializer registrations for one class should throw an IllegalStateException", (boolean)thrown);
    }

    public static class FooSerializer
    implements JSONSerializer<Foo> {
        public Foo deserialize(Type type, JsonValue jsonValue, ConnectorTracker connectorTracker) {
            return null;
        }

        public JsonValue serialize(Foo value, ConnectorTracker connectorTracker) {
            return null;
        }
    }

    public static class Foo {
    }
}

