/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.BootstrapHandler;
import com.vaadin.server.DefaultDeploymentConfiguration;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WebBrowser;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BootstrapHandlerTest {
    private static final String VAADIN_URL = "http://host/VAADIN/";

    @Test
    public void resolveFrontendES5() {
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "http://host/VAADIN/frontend/es5/foobar.html", new ES5Browser());
    }

    @Test
    public void resolveFrontendES6() {
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "http://host/VAADIN/frontend/es6/foobar.html", new ES6Browser());
    }

    @Test
    public void resolveFrontendES5CustomUrl() {
        Properties properties = new Properties();
        properties.setProperty("frontend.url.es5", "https://cdn.somewhere.com/5");
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "https://cdn.somewhere.com/5/foobar.html", new ES5Browser(), properties);
    }

    @Test
    public void resolveFrontendES6CustomUrl() {
        Properties properties = new Properties();
        properties.setProperty("frontend.url.es6", "https://cdn.somewhere.com/6");
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "https://cdn.somewhere.com/6/foobar.html", new ES6Browser(), properties);
    }

    private static void testResolveFrontEnd(String frontendUrl, String expectedUrl, WebBrowser browser) {
        BootstrapHandlerTest.testResolveFrontEnd(frontendUrl, expectedUrl, browser, new Properties());
    }

    private static void testResolveFrontEnd(String frontendUrl, String expectedUrl, WebBrowser browser, Properties customProperties) {
        BootstrapHandler.BootstrapContext context = (BootstrapHandler.BootstrapContext)Mockito.mock(BootstrapHandler.BootstrapContext.class);
        BootstrapHandler.BootstrapUriResolver resolver = new BootstrapHandler.BootstrapUriResolver(context){

            protected String getVaadinDirUrl() {
                return BootstrapHandlerTest.VAADIN_URL;
            }
        };
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)context.getSession()).thenReturn((Object)session);
        DefaultDeploymentConfiguration configuration = new DefaultDeploymentConfiguration(BootstrapHandlerTest.class, customProperties);
        Mockito.when((Object)session.getBrowser()).thenReturn((Object)browser);
        Mockito.when((Object)session.getConfiguration()).thenReturn((Object)configuration);
        Assert.assertEquals((Object)expectedUrl, (Object)resolver.resolveVaadinUri(frontendUrl));
    }

    public static class ES6Browser
    extends WebBrowser {
        public boolean isEs6Supported() {
            return true;
        }
    }

    public static class ES5Browser
    extends WebBrowser {
        public boolean isEs6Supported() {
            return false;
        }
    }
}

