/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.AbstractClientConnector;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.shared.communication.FieldRpc;
import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.ui.ClickRpc;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractClientConnectorTest {
    @Test
    public void registerRPCMultiInterfaceTest() {
        AbstractClientConnector mock = (AbstractClientConnector)Mockito.mock(AbstractClientConnector.class);
        MultiServerRpcMock implementation = new MultiServerRpcMock();
        ((AbstractClientConnector)Mockito.doCallRealMethod().when((Object)mock)).registerRpc((ServerRpc)implementation);
        try {
            mock.registerRpc((ServerRpc)implementation);
            Assert.fail((String)"expected exception");
        }
        catch (Exception expected) {
            Assert.assertEquals((Object)"Use registerRpc(T implementation, Class<T> rpcInterfaceType) if the Rpc implementation implements more than one interface", (Object)expected.getMessage());
        }
    }

    @Test
    public void registerRPCInterfaceTest() {
        AbstractClientConnector mock = (AbstractClientConnector)Mockito.mock(AbstractClientConnector.class);
        ServerRpcMock implementation = new ServerRpcMock();
        ((AbstractClientConnector)Mockito.doCallRealMethod().when((Object)mock)).registerRpc((ServerRpc)implementation);
        mock.registerRpc((ServerRpc)implementation);
        ((AbstractClientConnector)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).registerRpc((ServerRpc)implementation, ClickRpc.class);
    }

    @Test
    public void registerRPCInterfaceLastTest() {
        AbstractClientConnector mock = (AbstractClientConnector)Mockito.mock(AbstractClientConnector.class);
        ServerRpcLastMock implementation = new ServerRpcLastMock();
        ((AbstractClientConnector)Mockito.doCallRealMethod().when((Object)mock)).registerRpc((ServerRpc)implementation);
        mock.registerRpc((ServerRpc)implementation);
        ((AbstractClientConnector)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).registerRpc((ServerRpc)implementation, ClickRpc.class);
    }

    @Test
    public void stateTypeCacheDoesNotLeakMemory() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, InterruptedException, ClassNotFoundException {
        Field stateTypeCacheField = AbstractClientConnector.class.getDeclaredField("STATE_TYPE_CACHE");
        stateTypeCacheField.setAccessible(true);
        Map stateTypeCache = (Map)stateTypeCacheField.get(null);
        WeakReference<Class<?>> classRef = this.loadClass("com.vaadin.server.AbstractClientConnector");
        stateTypeCache.put((Class)classRef.get(), null);
        int size = stateTypeCache.size();
        Assert.assertNotNull((String)"Class should not yet be garbage collected", classRef.get());
        for (int i = 0; i < 100; ++i) {
            System.gc();
            if (stateTypeCache.size() < size) break;
            Thread.sleep(100L);
        }
        Assert.assertTrue((stateTypeCache.size() < size ? 1 : 0) != 0);
        Assert.assertNull((String)"Class should be garbage collected", classRef.get());
    }

    private WeakReference<Class<?>> loadClass(String name) throws ClassNotFoundException {
        TestClassLoader loader = new TestClassLoader();
        Class<?> loaded = ((ClassLoader)loader).loadClass(name);
        return new WeakReference(loaded);
    }

    private static class TestClassLoader
    extends ClassLoader {
        private TestClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> clazz;
            block9: {
                if (!name.startsWith("com.vaadin.")) {
                    return super.loadClass(name);
                }
                String path = name.replace('.', '/').concat(".class");
                URL resource = Thread.currentThread().getContextClassLoader().getResource(path);
                InputStream stream = resource.openStream();
                try {
                    byte[] bytes = IOUtils.toByteArray((InputStream)stream);
                    clazz = this.defineClass(name, bytes, 0, bytes.length);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException();
                    }
                }
                stream.close();
            }
            return clazz;
        }
    }

    private class MultiServerRpcMock
    implements ClickRpc,
    FieldRpc.BlurServerRpc {
        private static final long serialVersionUID = -7611999715560330373L;

        private MultiServerRpcMock() {
        }

        public void blur() {
        }

        public void click(MouseEventDetails mouseDetails) {
        }
    }

    private class ServerRpcMock
    implements ClickRpc {
        private static final long serialVersionUID = 2822356895755286180L;

        private ServerRpcMock() {
        }

        public void click(MouseEventDetails mouseDetails) {
        }
    }

    private class ServerRpcLastMock
    implements Comparable<ServerRpcLastMock>,
    ClickRpc {
        private static final long serialVersionUID = -2822356895755286180L;

        private ServerRpcLastMock() {
        }

        public void click(MouseEventDetails mouseDetails) {
        }

        @Override
        public int compareTo(ServerRpcLastMock o) {
            return 0;
        }
    }
}

