/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.event.selection;

import com.vaadin.event.selection.MultiSelectionEvent;
import com.vaadin.event.selection.SingleSelectionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SelectionEventTest {
    @Test
    public void getFirstSelected_mutliSelectEvent() {
        MultiSelectionEvent event = (MultiSelectionEvent)Mockito.mock(MultiSelectionEvent.class);
        ((MultiSelectionEvent)Mockito.doCallRealMethod().when((Object)event)).getFirstSelectedItem();
        Mockito.when((Object)((Set)event.getValue())).thenReturn(new LinkedHashSet<String>(Arrays.asList("foo", "bar")));
        Optional selected = event.getFirstSelectedItem();
        ((MultiSelectionEvent)Mockito.verify((Object)event)).getValue();
        Assert.assertEquals((Object)"foo", selected.get());
        Mockito.when((Object)((Set)event.getValue())).thenReturn(Collections.emptySet());
        Assert.assertFalse((boolean)event.getFirstSelectedItem().isPresent());
    }

    @Test
    public void getFirstSelected_singleSelectEvent() {
        SingleSelectionEvent event = (SingleSelectionEvent)Mockito.mock(SingleSelectionEvent.class);
        ((SingleSelectionEvent)Mockito.doCallRealMethod().when((Object)event)).getFirstSelectedItem();
        Mockito.when((Object)event.getSelectedItem()).thenReturn(Optional.of("foo"));
        Optional selected = event.getSelectedItem();
        ((SingleSelectionEvent)Mockito.verify((Object)event)).getSelectedItem();
        Assert.assertEquals((Object)"foo", selected.get());
        Mockito.when((Object)event.getSelectedItem()).thenReturn(Optional.empty());
        Assert.assertFalse((boolean)event.getFirstSelectedItem().isPresent());
    }
}

