/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.util;

import com.vaadin.data.util.BeanUtil;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class BeanUtilTest {
    @Test
    public void duplicatesAreRemoved() throws Exception {
        List descriptors = BeanUtil.getBeanPropertyDescriptors(TestSomething.class);
        List existsInAllPlacesProperties = descriptors.stream().filter(desc -> desc.getName().equals("existsInAllPlaces")).collect(Collectors.toList());
        Assert.assertEquals((String)"There should be only one 'existsInAllPlaces' property descriptor", (long)1L, (long)existsInAllPlacesProperties.size());
        List oneInterfaceProperties = descriptors.stream().filter(desc -> desc.getName().equals("oneInterface")).collect(Collectors.toList());
        Assert.assertEquals((String)"There should be only one 'oneInterface' property descriptor", (long)1L, (long)oneInterfaceProperties.size());
        PropertyDescriptor oneInterfaceProperty = (PropertyDescriptor)oneInterfaceProperties.get(0);
        Assert.assertEquals(FirstInterface.class, oneInterfaceProperty.getReadMethod().getDeclaringClass());
    }

    public class TestSomething
    implements FirstInterface,
    SecondInterface {
        @Override
        public void setExistsInAllPlaces(boolean visible) {
        }

        @Override
        public boolean isExistsInAllPlaces() {
            return true;
        }
    }

    public static interface SecondInterface {
        default public void setExistsInAllPlaces(boolean visible) {
        }

        default public boolean isExistsInAllPlaces() {
            return true;
        }
    }

    public static interface FirstInterface {
        default public void setOneInterface(boolean bothInterfaces) {
        }

        default public boolean isOneInterface() {
            return true;
        }

        default public void setExistsInAllPlaces(boolean visible) {
        }

        default public boolean isExistsInAllPlaces() {
            return true;
        }
    }
}

