/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider.hierarchical;

import com.vaadin.data.TreeData;
import com.vaadin.data.provider.DataCommunicatorTest;
import com.vaadin.data.provider.HierarchicalDataCommunicator;
import com.vaadin.data.provider.HierarchicalDataProvider;
import com.vaadin.data.provider.TreeDataProvider;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.VaadinService;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HierarchicalCommunicatorTest {
    private static final String ROOT = "ROOT";
    private static final String FOLDER = "FOLDER";
    private static final String LEAF = "LEAF";
    private TreeDataProvider<String> dataProvider;
    private TestHierarchicalDataCommunicator<String> communicator;
    private TreeData<String> treeData;

    @Before
    public void setUp() {
        MockVaadinSession session = new MockVaadinSession((VaadinService)Mockito.mock(VaadinService.class));
        session.lock();
        DataCommunicatorTest.TestUI ui = new DataCommunicatorTest.TestUI(session);
        this.treeData = new TreeData();
        this.treeData.addItems(null, (Object[])new String[]{ROOT});
        this.treeData.addItems((Object)ROOT, (Object[])new String[]{FOLDER});
        this.treeData.addItems((Object)FOLDER, (Object[])new String[]{LEAF});
        this.dataProvider = new TreeDataProvider(this.treeData);
        this.communicator = new TestHierarchicalDataCommunicator();
        this.communicator.extend((AbstractClientConnector)ui);
        this.communicator.setDataProvider((HierarchicalDataProvider)this.dataProvider, null);
        this.communicator.attach();
    }

    @Test
    public void testFolderRemoveRefreshAll() {
        this.testItemRemove(FOLDER, true);
    }

    @Test
    public void testLeafRemoveRefreshAll() {
        this.testItemRemove(LEAF, true);
    }

    @Test
    public void testFolderRemove() {
        this.testItemRemove(FOLDER, false);
    }

    @Test
    public void testLeafRemove() {
        this.testItemRemove(LEAF, false);
    }

    private void testItemRemove(String item, boolean refreshAll) {
        this.communicator.pushData(1, Arrays.asList(ROOT, FOLDER, LEAF));
        this.communicator.expand(ROOT);
        this.communicator.expand(FOLDER);
        this.communicator.refresh(item);
        this.treeData.removeItem((Object)item);
        if (refreshAll) {
            this.dataProvider.refreshAll();
        } else {
            this.dataProvider.refreshItem((Object)item);
        }
        this.communicator.beforeClientResponse(false);
    }

    @Test
    public void testReplaceAll() {
        this.communicator.pushData(1, Arrays.asList(ROOT, FOLDER, LEAF));
        this.communicator.expand(ROOT);
        this.communicator.expand(FOLDER);
        this.communicator.refresh(LEAF);
        this.communicator.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(new TreeData()), null);
        this.dataProvider.refreshAll();
        this.communicator.beforeClientResponse(false);
        Assert.assertFalse((String)"Stalled object in KeyMapper", (boolean)this.communicator.getKeyMapper().has((Object)ROOT));
        Assert.assertEquals((long)-1L, (long)this.communicator.getParentIndex(FOLDER).longValue());
    }

    private static class TestHierarchicalDataCommunicator<T>
    extends HierarchicalDataCommunicator<T> {
        private TestHierarchicalDataCommunicator() {
        }

        public void extend(AbstractClientConnector target) {
            super.extend(target);
        }

        public void pushData(int firstIndex, List<T> data) {
            super.pushData(firstIndex, data);
        }
    }
}

