/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.provider.DataCommunicator;
import com.vaadin.data.provider.DataGenerator;
import com.vaadin.data.provider.DataKeyMapper;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.DataProviderListener;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.SerializableConsumer;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.Range;
import com.vaadin.shared.Registration;
import com.vaadin.ui.UI;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DataCommunicatorTest {
    private static final Object TEST_OBJECT = new Object();
    private static final Object TEST_OBJECT_TWO = new Object();
    private final MockVaadinSession session = new MockVaadinSession((VaadinService)Mockito.mock(VaadinService.class));

    @Test
    public void attach_dataProviderListenerIsNotAddedBeforeAttachAndAddedAfter() {
        this.session.lock();
        TestUI ui = new TestUI(this.session);
        TestDataCommunicator communicator = new TestDataCommunicator();
        TestDataProvider dataProvider = new TestDataProvider();
        communicator.setDataProvider((DataProvider)dataProvider, null);
        Assert.assertFalse((boolean)dataProvider.isListenerAdded());
        communicator.extend(ui);
        Assert.assertTrue((boolean)dataProvider.isListenerAdded());
    }

    @Test
    public void detach_dataProviderListenerIsRemovedAfterDetach() {
        this.session.lock();
        TestUI ui = new TestUI(this.session);
        TestDataCommunicator communicator = new TestDataCommunicator();
        TestDataProvider dataProvider = new TestDataProvider();
        communicator.setDataProvider((DataProvider)dataProvider, null);
        communicator.extend(ui);
        Assert.assertTrue((boolean)dataProvider.isListenerAdded());
        communicator.detach();
        Assert.assertFalse((boolean)dataProvider.isListenerAdded());
    }

    @Test
    public void refresh_dataProviderListenerCallsRefreshInDataGeneartors() {
        this.session.lock();
        TestUI ui = new TestUI(this.session);
        TestDataCommunicator communicator = new TestDataCommunicator();
        communicator.extend(ui);
        TestDataProvider dataProvider = new TestDataProvider();
        communicator.setDataProvider((DataProvider)dataProvider, null);
        TestDataGenerator generator = new TestDataGenerator();
        communicator.addDataGenerator(generator);
        communicator.beforeClientResponse(true);
        Assert.assertEquals((String)"DataGenerator generate was not called", (Object)TEST_OBJECT, (Object)generator.generated);
        generator.generated = null;
        communicator.beforeClientResponse(false);
        Assert.assertEquals((String)"DataGenerator generate was called again", null, (Object)generator.generated);
        dataProvider.refreshItem(TEST_OBJECT);
        Assert.assertEquals((String)"DataGenerator refresh was not called", (Object)TEST_OBJECT, (Object)generator.refreshed);
        communicator.beforeClientResponse(false);
        Assert.assertEquals((String)"DataGenerator generate was not called", (Object)TEST_OBJECT, (Object)generator.generated);
    }

    @Test
    public void refreshDataProviderRemovesOldObjectsFromActiveDataHandler() {
        this.session.lock();
        TestUI ui = new TestUI(this.session);
        TestDataProvider dataProvider = new TestDataProvider();
        TestDataCommunicator communicator = new TestDataCommunicator();
        communicator.setDataProvider((DataProvider)dataProvider, null);
        communicator.extend(ui);
        communicator.beforeClientResponse(true);
        DataKeyMapper keyMapper = communicator.getKeyMapper();
        Assert.assertTrue((String)"Object not mapped by key mapper", (boolean)keyMapper.has(TEST_OBJECT));
        DataCommunicator.ActiveDataHandler handler = communicator.getActiveDataHandler();
        Assert.assertTrue((String)"Object not amongst active data", (boolean)handler.getActiveData().containsKey(TEST_OBJECT));
        dataProvider.setItem(TEST_OBJECT_TWO);
        dataProvider.refreshAll();
        communicator.beforeClientResponse(false);
        Assert.assertTrue((String)"Object not marked as dropped", (boolean)handler.getDroppedData().containsKey(TEST_OBJECT));
        communicator.setPushRows(Range.between((int)0, (int)communicator.getMinPushSize()));
        communicator.beforeClientResponse(false);
        Assert.assertFalse((String)"Object still mapped by key mapper", (boolean)keyMapper.has(TEST_OBJECT));
        Assert.assertTrue((String)"Object not mapped by key mapper", (boolean)keyMapper.has(TEST_OBJECT_TWO));
        Assert.assertFalse((String)"Object still amongst active data", (boolean)handler.getActiveData().containsKey(TEST_OBJECT));
        Assert.assertTrue((String)"Object not amongst active data", (boolean)handler.getActiveData().containsKey(TEST_OBJECT_TWO));
    }

    @Test
    public void testDestroyData() {
        this.session.lock();
        TestUI ui = new TestUI(this.session);
        TestDataCommunicator communicator = new TestDataCommunicator();
        TestDataProvider dataProvider = new TestDataProvider();
        communicator.setDataProvider((DataProvider)dataProvider, null);
        communicator.extend(ui);
        communicator.pushData(1, Collections.singletonList(TEST_OBJECT));
        communicator.refresh(TEST_OBJECT);
        String key = communicator.getKeyMapper().key(TEST_OBJECT);
        JsonArray keys = Json.createArray();
        keys.set(0, key);
        communicator.onDropRows(keys);
        communicator.setDataProvider((DataProvider)new ListDataProvider(Collections.singleton(new Object())));
        communicator.beforeClientResponse(false);
        Assert.assertFalse((String)"Stalled object in KeyMapper", (boolean)communicator.getKeyMapper().has(TEST_OBJECT));
    }

    @Test
    public void testFilteringLock() {
        this.session.lock();
        TestUI ui = new TestUI(this.session);
        TestDataCommunicator communicator = new TestDataCommunicator();
        communicator.extend(ui);
        ListDataProvider dataProvider = DataProvider.ofItems((Object[])new Object[]{"one", "two", "three"});
        SerializableConsumer filterSlot = communicator.setDataProvider((DataProvider)dataProvider, null);
        communicator.beforeClientResponse(true);
        filterSlot.accept((SerializablePredicate & Serializable)t -> String.valueOf(t).contains("a"));
        communicator.beforeClientResponse(false);
        filterSlot.accept((SerializablePredicate & Serializable)t -> String.valueOf(t).contains(""));
        communicator.beforeClientResponse(false);
        communicator.onRequestRows(0, 3, 0, 0);
        filterSlot.accept((SerializablePredicate & Serializable)t -> String.valueOf(t).contains("a"));
        communicator.beforeClientResponse(false);
        ui.getConnectorTracker().markClean((ClientConnector)communicator);
        Assert.assertTrue((String)"Communicator should be marked for hard reset", (boolean)communicator.reset);
        Assert.assertFalse((String)"DataCommunicator should not be marked as dirty", (boolean)ui.getConnectorTracker().isDirty((ClientConnector)communicator));
        filterSlot.accept((SerializablePredicate & Serializable)t -> String.valueOf(t).contains(""));
        Assert.assertTrue((String)"DataCommunicator should be marked as dirty", (boolean)ui.getConnectorTracker().isDirty((ClientConnector)communicator));
    }

    @Test(expected=IllegalStateException.class)
    public void requestTooMuchRowsFail() {
        TestDataCommunicator communicator = new TestDataCommunicator();
        communicator.onRequestRows(0, communicator.getMaximumAllowedRows() + 10, 0, 0);
    }

    @Test
    public void requestTooMuchRowsOverride() {
        TestDataCommunicator communicator = new TestDataCommunicator();
        int maxRows = communicator.getMaximumAllowedRows();
        communicator.setMaximumAllowedRows(maxRows + 100);
        communicator.onRequestRows(0, maxRows + 10, 0, 0);
    }

    private static class TestDataGenerator
    implements DataGenerator<Object> {
        Object refreshed = null;
        Object generated = null;

        private TestDataGenerator() {
        }

        public void generateData(Object item, JsonObject jsonObject) {
            this.generated = item;
        }

        public void refreshData(Object item) {
            this.refreshed = item;
        }
    }

    private static class TestDataCommunicator
    extends DataCommunicator<Object> {
        private TestDataCommunicator() {
        }

        protected void extend(UI ui) {
            super.extend((AbstractClientConnector)ui);
        }
    }

    private static class TestDataProvider
    extends ListDataProvider<Object>
    implements Registration {
        private Registration registration;

        public TestDataProvider() {
            super(new ArrayList());
            this.addItem(TEST_OBJECT);
        }

        public Registration addDataProviderListener(DataProviderListener<Object> listener) {
            this.registration = super.addDataProviderListener(listener);
            return this;
        }

        public void remove() {
            this.registration.remove();
            this.registration = null;
        }

        public boolean isListenerAdded() {
            return this.registration != null;
        }

        public void setItem(Object item) {
            this.clear();
            this.addItem(item);
        }

        public void clear() {
            this.getItems().clear();
        }

        public void addItem(Object item) {
            this.getItems().add(item);
        }
    }

    public static class TestUI
    extends UI {
        private final VaadinSession session;

        public TestUI(VaadinSession session) {
            this.session = session;
        }

        protected void init(VaadinRequest request) {
        }

        public VaadinSession getSession() {
            return this.session;
        }

        public Future<Void> access(Runnable runnable) {
            runnable.run();
            return null;
        }
    }
}

