/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.tests.data.bean.BeanWithEnums;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.tests.data.bean.TestEnum;
import com.vaadin.ui.Grid;
import com.vaadin.ui.MultiSelect;
import com.vaadin.ui.components.grid.GridMultiSelect;
import com.vaadin.ui.components.grid.GridSelectionModel;
import com.vaadin.ui.components.grid.MultiSelectionModelImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridAsMultiSelectInBinderTest
extends BinderTestBase<Binder<BeanWithEnums>, BeanWithEnums> {
    private Binder<AtomicReference<String>> converterBinder = new Binder();
    private Grid<TestEnum> grid;
    private MultiSelect<TestEnum> select;

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new BeanWithEnums();
        this.grid = new Grid();
        this.grid.setItems((Object[])TestEnum.values());
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.select = this.grid.asMultiSelect();
        this.converterBinder.forField(this.select).withConverter((Converter)new TestEnumSetToStringConverter()).bind(AtomicReference::get, AtomicReference::set);
    }

    @Test(expected=IllegalStateException.class)
    public void boundGridInBinder_selectionModelChanged_throws() {
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.select.select((Object[])new TestEnum[]{TestEnum.ONE});
    }

    @Test
    public void beanBound_bindSelectByShortcut_selectionUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.binder.setBean((Object)((BeanWithEnums)this.item));
        this.binder.bind(this.select, BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        Assert.assertEquals(Collections.singleton(TestEnum.ONE), (Object)this.select.getSelectedItems());
    }

    @Test
    public void beanBound_bindSelect_selectionUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.TWO));
        this.binder.setBean((Object)((BeanWithEnums)this.item));
        this.binder.forField(this.select).bind(BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), (Object)this.select.getSelectedItems());
    }

    @Test
    public void selectBound_bindBeanWithoutEnums_selectedItemNotPresent() {
        this.bindEnum();
        Assert.assertTrue((boolean)this.select.getSelectedItems().isEmpty());
    }

    @Test
    public void selectBound_bindBean_selectionUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.bindEnum();
        Assert.assertEquals(Collections.singleton(TestEnum.ONE), (Object)this.select.getSelectedItems());
    }

    @Test
    public void bound_setSelection_beanValueUpdated() {
        this.bindEnum();
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), ((BeanWithEnums)this.item).getEnums());
    }

    @Test
    public void bound_setSelection_beanValueIsACopy() {
        this.bindEnum();
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Set<TestEnum> enums = ((BeanWithEnums)this.item).getEnums();
        this.binder.setBean((Object)new BeanWithEnums());
        this.select.select((Object[])new TestEnum[]{TestEnum.ONE});
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), enums);
    }

    @Test
    public void bound_deselect_beanValueUpdatedToNull() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.bindEnum();
        this.select.deselect((Object[])new TestEnum[]{TestEnum.ONE});
        Assert.assertTrue((boolean)((BeanWithEnums)this.item).getEnums().isEmpty());
    }

    @Test
    public void unbound_changeSelection_beanValueNotUpdated() {
        ((BeanWithEnums)this.item).setEnums(Collections.singleton(TestEnum.ONE));
        this.bindEnum();
        this.binder.removeBean();
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Assert.assertEquals(Collections.singleton(TestEnum.ONE), ((BeanWithEnums)this.item).getEnums());
    }

    @Test
    public void withConverter_load_selectUpdated() {
        this.converterBinder.readBean(new AtomicReference<String>("TWO"));
        Assert.assertEquals(Collections.singleton(TestEnum.TWO), (Object)this.select.getSelectedItems());
    }

    @Test
    public void withConverter_save_referenceUpdated() {
        this.select.select((Object[])new TestEnum[]{TestEnum.ONE});
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        AtomicReference<String> reference = new AtomicReference<String>("");
        this.converterBinder.writeBeanIfValid(reference);
        Assert.assertEquals((Object)"ONE,TWO", (Object)reference.get());
    }

    @Test
    public void withValidator_validate_validatorUsed() {
        this.binder.forField(this.select).withValidator((SerializablePredicate & Serializable)selection -> selection.size() % 2 == 1, "Must select odd number of items").bind(BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        this.binder.setBean((Object)((BeanWithEnums)this.item));
        Assert.assertFalse((boolean)this.binder.validate().isOk());
        this.select.select((Object[])new TestEnum[]{TestEnum.TWO});
        Assert.assertTrue((boolean)this.binder.validate().isOk());
    }

    @Test
    public void addValueChangeListener_selectionUpdated_eventTriggeredForMultiSelect() {
        final CustomMultiSelectModel model = new CustomMultiSelectModel();
        Grid<Sex> grid = new Grid<Sex>(){
            {
                this.setSelectionModel((GridSelectionModel)model);
            }
        };
        grid.setItems((Object[])Sex.values());
        GridMultiSelect select = grid.asMultiSelect();
        ArrayList selected = new ArrayList();
        ArrayList userOriginated = new ArrayList();
        select.addValueChangeListener(arg_0 -> GridAsMultiSelectInBinderTest.lambda$addValueChangeListener_selectionUpdated_eventTriggeredForMultiSelect$f0815ee2$1(selected, userOriginated, (Grid)grid, (MultiSelect)select, arg_0));
        select.select((Object[])new Sex[]{Sex.UNKNOWN});
        Assert.assertEquals(Arrays.asList(Sex.UNKNOWN), selected);
        model.updateSelection(new LinkedHashSet<Sex>(Arrays.asList(Sex.MALE)), Collections.emptySet(), true);
        Assert.assertEquals(Arrays.asList(Sex.UNKNOWN, Sex.UNKNOWN, Sex.MALE), selected);
        selected.clear();
        select.select((Object[])new Sex[]{Sex.MALE});
        Assert.assertEquals(Arrays.asList(new Object[0]), selected);
        selected.clear();
        model.updateSelection(Collections.emptySet(), new LinkedHashSet<Sex>(Arrays.asList(Sex.UNKNOWN)), true);
        Assert.assertEquals(Arrays.asList(Sex.MALE), selected);
        selected.clear();
        select.deselect((Object[])new Sex[]{Sex.UNKNOWN});
        Assert.assertEquals(Arrays.asList(new Object[0]), selected);
        selected.clear();
        select.deselect((Object[])new Sex[]{Sex.FEMALE, Sex.MALE});
        Assert.assertEquals(Arrays.asList(new Object[0]), selected);
        model.selectItems((Object[])new Sex[]{Sex.FEMALE, Sex.MALE});
        Assert.assertEquals(Arrays.asList(Sex.FEMALE, Sex.MALE), selected);
        selected.clear();
        model.updateSelection(new LinkedHashSet<Sex>(Arrays.asList(Sex.FEMALE)), Collections.emptySet(), true);
        Assert.assertEquals(Arrays.asList(new Object[0]), selected);
        Assert.assertEquals(Arrays.asList(false, true, true, false, false), userOriginated);
    }

    protected void bindEnum() {
        this.binder.forField(this.select).bind(BeanWithEnums::getEnums, BeanWithEnums::setEnums);
        this.binder.setBean((Object)((BeanWithEnums)this.item));
    }

    private static /* synthetic */ void lambda$addValueChangeListener_selectionUpdated_eventTriggeredForMultiSelect$f0815ee2$1(List selected, List userOriginated, Grid grid, MultiSelect select, HasValue.ValueChangeEvent event) {
        selected.addAll((Collection)event.getValue());
        userOriginated.add(event.isUserOriginated());
        Assert.assertSame((Object)grid, (Object)event.getComponent());
        Assert.assertEquals((Object)select.getValue(), (Object)event.getValue());
    }

    private class CustomMultiSelectModel
    extends MultiSelectionModelImpl<Sex> {
        private CustomMultiSelectModel() {
        }

        public void updateSelection(Set<Sex> addedItems, Set<Sex> removedItems, boolean userOriginated) {
            super.updateSelection(addedItems, removedItems, userOriginated);
        }
    }

    public class TestEnumSetToStringConverter
    implements Converter<Set<TestEnum>, String> {
        public Result<String> convertToModel(Set<TestEnum> value, ValueContext context) {
            return Result.ok((Object)value.stream().map(Enum::name).collect(Collectors.joining(",")));
        }

        public Set<TestEnum> convertToPresentation(String value, ValueContext context) {
            return Stream.of(value.split(",")).filter(string -> !string.isEmpty()).map(TestEnum::valueOf).collect(Collectors.toSet());
        }
    }
}

