/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.ui.TextField;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderValueChangeTest
extends BinderTestBase<Binder<Person>, Person> {
    private AtomicReference<HasValue.ValueChangeEvent<?>> event;

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new Person();
        this.event = new AtomicReference();
    }

    @Test
    public void unboundField_noEvents() {
        this.binder.addValueChangeListener(this::statusChanged);
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        this.nameField.setValue("");
        Assert.assertNull(this.event.get());
        binding.bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull(this.event.get());
    }

    @Test
    public void setBean_unbound_noEvents() {
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull(this.event.get());
    }

    @Test
    public void readBean_unbound_noEvents() {
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertNull(this.event.get());
    }

    @Test
    public void setValue_unbound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent((HasValue<?>)this.nameField);
    }

    @Test
    public void setValue_bound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent((HasValue<?>)this.nameField);
    }

    @Test
    public void userOriginatedUpdate_unbound_singleEventOnSetValue() {
        TestTextField field = new TestTextField();
        this.binder.forField((HasValue)field).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.addValueChangeListener(this::statusChanged);
        Assert.assertNull(this.event.get());
        field.setValue("foo", true);
        this.verifyEvent((HasValue<?>)field, true);
    }

    @Test
    public void addListenerFirst_bound_singleEventOnSetValue() {
        this.binder.addValueChangeListener(this::statusChanged);
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull(this.event.get());
        this.ageField.setValue(String.valueOf(1));
        this.verifyEvent((HasValue<?>)this.ageField);
    }

    private void verifyEvent(HasValue<?> field) {
        this.verifyEvent(field, false);
    }

    private void verifyEvent(HasValue<?> field, boolean isUserOriginated) {
        HasValue.ValueChangeEvent<?> changeEvent = this.event.get();
        Assert.assertNotNull(changeEvent);
        Assert.assertEquals(field, (Object)changeEvent.getSource());
        Assert.assertEquals(field, (Object)changeEvent.getComponent());
        Assert.assertEquals((Object)isUserOriginated, (Object)changeEvent.isUserOriginated());
    }

    private void statusChanged(HasValue.ValueChangeEvent<?> evt) {
        Assert.assertNull(this.event.get());
        this.event.set(evt);
    }

    private static class TestTextField
    extends TextField {
        private TestTextField() {
        }

        protected boolean setValue(String value, boolean userOriginated) {
            return super.setValue((Object)value, userOriginated);
        }
    }
}

