/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.BinderValidationStatusHandler;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.data.BindingValidationStatusHandler;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.ui.Label;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderValidationStatusTest
extends BinderTestBase<Binder<Person>, Person> {
    protected static final BindingValidationStatusHandler NOOP = (BindingValidationStatusHandler & Serializable)event -> {};

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new Person();
        ((Person)this.item).setFirstName("Johannes");
        ((Person)this.item).setAge(32);
    }

    @Test
    public void bindingWithStatusHandler_handlerGetsEvents() {
        AtomicReference statusCapture = new AtomicReference();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> {
            Assert.assertNull(statusCapture.get());
            statusCapture.set(evt);
        });
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setValue("");
        this.binder.validate();
        Assert.assertNotNull(statusCapture.get());
        BindingValidationStatus evt2 = (BindingValidationStatus)statusCapture.get();
        Assert.assertEquals((Object)BindingValidationStatus.Status.ERROR, (Object)evt2.getStatus());
        Assert.assertEquals((Object)"Value cannot be empty", evt2.getMessage().get());
        Assert.assertEquals((Object)this.nameField, (Object)evt2.getField());
        statusCapture.set(null);
        this.nameField.setValue("foo");
        statusCapture.set(null);
        this.binder.validate();
        evt2 = (BindingValidationStatus)statusCapture.get();
        Assert.assertNotNull((Object)evt2);
        Assert.assertEquals((Object)BindingValidationStatus.Status.OK, (Object)evt2.getStatus());
        Assert.assertFalse((boolean)evt2.getMessage().isPresent());
        Assert.assertEquals((Object)this.nameField, (Object)evt2.getField());
    }

    @Test
    public void bindingWithStatusHandler_defaultStatusHandlerIsReplaced() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> {}).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("");
        binding.validate();
        Assert.assertNull((Object)this.nameField.getComponentError());
    }

    @Test
    public void bindingWithStatusLabel_labelIsUpdatedAccordingStatus() {
        Label label = new Label();
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withStatusLabel(label).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setValue("");
        binding.validate();
        Assert.assertTrue((boolean)label.isVisible());
        Assert.assertEquals((Object)"Value cannot be empty", (Object)label.getValue());
        this.nameField.setValue("foo");
        binding.validate();
        Assert.assertFalse((boolean)label.isVisible());
        Assert.assertEquals((Object)"", (Object)label.getValue());
    }

    @Test
    public void bindingWithStatusLabel_defaultStatusHandlerIsReplaced() {
        Label label = new Label();
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withStatusLabel(label).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("");
        binding.validate();
        Assert.assertNull((Object)this.nameField.getComponentError());
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusHandler_addAfterBound() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail());
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusLabel_addAfterBound() {
        Label label = new Label();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withStatusLabel(label);
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusLabel_setAfterHandler() {
        Label label = new Label();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withValidationStatusHandler(NOOP);
        binding.withStatusLabel(label);
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusHandler_setAfterLabel() {
        Label label = new Label();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withStatusLabel(label);
        binding.withValidationStatusHandler(NOOP);
    }

    @Test(expected=IllegalStateException.class)
    public void bindingWithStatusHandler_setAfterOtherHandler() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withValidationStatusHandler(NOOP);
        binding.withValidationStatusHandler(NOOP);
    }

    @Test
    public void binderWithStatusHandler_fieldValidationNoBeanValidation_handlerGetsStatusUpdates() {
        AtomicReference statusCapture = new AtomicReference();
        this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter(this.stringToInteger).withValidator(this.notNegative).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getAge, Person::setAge);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)r -> statusCapture.set(r));
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("");
        this.ageField.setValue("5");
        BinderValidationStatus status2 = this.binder.validate();
        BinderValidationStatus status = (BinderValidationStatus)statusCapture.get();
        Assert.assertSame((Object)status2, (Object)status);
        Assert.assertNull((Object)this.nameField.getComponentError());
        List bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertNotNull((Object)bindingStatuses);
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        BindingValidationStatus r2 = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertTrue((boolean)r2.isError());
        Assert.assertEquals((Object)"Value cannot be empty", r2.getMessage().get());
        Assert.assertEquals((Object)this.nameField, (Object)r2.getField());
        r2 = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertFalse((boolean)r2.isError());
        Assert.assertFalse((boolean)r2.getMessage().isPresent());
        Assert.assertEquals((Object)this.ageField, (Object)r2.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        this.nameField.setValue("foo");
        this.ageField.setValue("");
        statusCapture.set(null);
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        r2 = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertFalse((boolean)r2.isError());
        Assert.assertFalse((boolean)r2.getMessage().isPresent());
        Assert.assertEquals((Object)this.nameField, (Object)r2.getField());
        r2 = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertTrue((boolean)r2.isError());
        Assert.assertEquals((Object)"Value must be a number", r2.getMessage().get());
        Assert.assertEquals((Object)this.ageField, (Object)r2.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        statusCapture.set(null);
        this.ageField.setValue("0");
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
    }

    @Test
    public void binderWithStatusHandler_fieldAndBeanLevelValidation_handlerGetsStatusUpdates() {
        AtomicReference statusCapture = new AtomicReference();
        this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter(this.stringToInteger).withValidator(this.notNegative).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail((String)"Using a custom status change handler so no change should end up here")).bind(Person::getAge, Person::setAge);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> !bean.getFirstName().isEmpty() && bean.getAge() > 0, "Need first name and age");
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)r -> statusCapture.set(r));
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("");
        this.ageField.setValue("5");
        BinderValidationStatus status2 = this.binder.validate();
        BinderValidationStatus status = (BinderValidationStatus)statusCapture.get();
        Assert.assertSame((Object)status2, (Object)status);
        Assert.assertNull((Object)this.nameField.getComponentError());
        List bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertNotNull((Object)bindingStatuses);
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        BindingValidationStatus r2 = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertTrue((boolean)r2.isError());
        Assert.assertEquals((Object)"Value cannot be empty", r2.getMessage().get());
        Assert.assertEquals((Object)this.nameField, (Object)r2.getField());
        r2 = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertFalse((boolean)r2.isError());
        Assert.assertFalse((boolean)r2.getMessage().isPresent());
        Assert.assertEquals((Object)this.ageField, (Object)r2.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        this.nameField.setValue("foo");
        this.ageField.setValue("");
        statusCapture.set(null);
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        r2 = (BindingValidationStatus)bindingStatuses.get(0);
        Assert.assertFalse((boolean)r2.isError());
        Assert.assertFalse((boolean)r2.getMessage().isPresent());
        Assert.assertEquals((Object)this.nameField, (Object)r2.getField());
        r2 = (BindingValidationStatus)bindingStatuses.get(1);
        Assert.assertTrue((boolean)r2.isError());
        Assert.assertEquals((Object)"Value must be a number", r2.getMessage().get());
        Assert.assertEquals((Object)this.ageField, (Object)r2.getField());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        statusCapture.set(null);
        this.ageField.setValue("0");
        this.binder.validate();
        status = (BinderValidationStatus)statusCapture.get();
        bindingStatuses = status.getFieldValidationStatuses();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)bindingStatuses.size());
        Assert.assertEquals((long)1L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)1L, (long)status.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"Need first name and age", (Object)((ValidationResult)status.getBeanValidationErrors().get(0)).getErrorMessage());
    }

    @Test
    public void binderWithStatusHandler_defaultStatusHandlerIsReplaced() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> {}).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("");
        binding.validate();
        Assert.assertNull((Object)this.nameField.getComponentError());
    }

    @Test
    public void binderWithStatusLabel_defaultStatusHandlerIsReplaced() {
        Label label = new Label();
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty).withStatusLabel(label).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("");
        binding.validate();
        Assert.assertNull((Object)this.nameField.getComponentError());
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusHandler_addAfterBound() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withValidationStatusHandler((BindingValidationStatusHandler & Serializable)evt -> Assert.fail());
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusLabel_addAfterBound() {
        Label label = new Label();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        binding.withStatusLabel(label);
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusLabel_setAfterHandler() {
        Label label = new Label();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)event -> {});
        this.binder.setStatusLabel(label);
    }

    @Test(expected=IllegalStateException.class)
    public void binderWithStatusHandler_setAfterLabel() {
        Label label = new Label();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setStatusLabel(label);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)event -> {});
    }

    @Test(expected=NullPointerException.class)
    public void binderWithNullStatusHandler_throws() {
        this.binder.setValidationStatusHandler(null);
    }

    @Test
    public void binderWithStatusHandler_replaceHandler() {
        AtomicReference capture = new AtomicReference();
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)results -> Assert.fail());
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)results -> capture.set(results));
        this.nameField.setValue("foo");
        this.binder.validate();
        List results2 = ((BinderValidationStatus)capture.get()).getFieldValidationStatuses();
        Assert.assertNotNull((Object)results2);
        Assert.assertEquals((long)1L, (long)results2.size());
        Assert.assertFalse((boolean)((BindingValidationStatus)results2.get(0)).isError());
    }

    @Test
    public void binderValidationStatus_nullBindingStatuses() {
        try {
            new BinderValidationStatus(new Binder(), null, new ArrayList());
            Assert.fail((String)"Binder should throw an NPE");
        }
        catch (NullPointerException npe) {
            Assert.assertNotNull((Object)npe.getMessage());
        }
    }
}

