/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationException;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.data.validator.NotEmptyValidator;
import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.UserError;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderConverterValidatorTest
extends BinderTestBase<Binder<Person>, Person> {
    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new Person();
        ((Person)this.item).setFirstName("Johannes");
        ((Person)this.item).setAge(32);
    }

    @Test
    public void validate_notBound_noErrors() {
        BinderValidationStatus status = this.binder.validate();
        Assert.assertTrue((boolean)status.isOk());
    }

    @Test
    public void bound_validatorsAreOK_noErrors() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withValidator(Validator.alwaysPass()).bind(Person::getFirstName, Person::setFirstName);
        this.nameField.setComponentError((ErrorMessage)new UserError(""));
        BinderValidationStatus status = this.binder.validate();
        Assert.assertTrue((boolean)status.isOk());
        Assert.assertNull((Object)this.nameField.getComponentError());
    }

    @Test
    public void bound_validatorsFail_errors() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        binding.withValidator(Validator.alwaysPass());
        String msg1 = "foo";
        String msg2 = "bar";
        binding.withValidator((Validator & Serializable)(value, context) -> ValidationResult.error((String)msg1));
        binding.withValidator((SerializablePredicate & Serializable)value -> false, msg2);
        binding.bind(Person::getFirstName, Person::setFirstName);
        BinderValidationStatus status = this.binder.validate();
        List errors = status.getFieldValidationErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        BindingValidationStatus validationStatus = (BindingValidationStatus)errors.stream().findFirst().get();
        String msg = (String)validationStatus.getMessage().get();
        Assert.assertEquals((Object)msg1, (Object)msg);
        HasValue field = validationStatus.getField();
        Assert.assertEquals((Object)this.nameField, (Object)field);
        ErrorMessage componentError = this.nameField.getComponentError();
        Assert.assertNotNull((Object)componentError);
        Assert.assertEquals((Object)"foo", (Object)((AbstractErrorMessage)componentError).getMessage());
    }

    @Test
    public void validatorForSuperTypeCanBeUsed() {
        TextField salaryField = new TextField();
        Validator & Serializable positiveNumberValidator = (Validator & Serializable)(value, context) -> {
            if (value.doubleValue() >= 0.0) {
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)"Value must be non-negative");
        };
        this.binder.forField((HasValue)salaryField).withConverter(Double::valueOf, String::valueOf).withValidator((Validator)positiveNumberValidator).bind(Person::getSalaryDouble, Person::setSalaryDouble);
        Person person = new Person();
        this.binder.setBean((Object)person);
        salaryField.setValue("10");
        Assert.assertEquals((double)10.0, (double)person.getSalaryDouble(), (double)0.0);
        salaryField.setValue("-1");
        Assert.assertEquals((double)10.0, (double)person.getSalaryDouble(), (double)0.0);
    }

    @Test
    public void convertInitialValue() {
        this.bindAgeWithValidatorConverterValidator();
        Assert.assertEquals((Object)"32", (Object)this.ageField.getValue());
    }

    @Test
    public void convertToModelValidAge() {
        this.bindAgeWithValidatorConverterValidator();
        this.ageField.setValue("33");
        Assert.assertEquals((long)33L, (long)((Person)this.item).getAge());
    }

    @Test
    public void convertToModelNegativeAgeFailsOnFirstValidator() {
        this.bindAgeWithValidatorConverterValidator();
        this.ageField.setValue("");
        Assert.assertEquals((long)32L, (long)((Person)this.item).getAge());
        this.assertValidationErrors((BinderValidationStatus<Person>)this.binder.validate(), "Value cannot be empty");
    }

    private void assertValidationErrors(List<BindingValidationStatus<?>> validationErrors, String ... errorMessages) {
        Assert.assertEquals((long)errorMessages.length, (long)validationErrors.size());
        for (int i = 0; i < errorMessages.length; ++i) {
            Assert.assertEquals((Object)errorMessages[i], validationErrors.get(i).getMessage().get());
        }
    }

    private void assertValidationErrors(BinderValidationStatus<Person> status, String ... errorMessages) {
        this.assertValidationErrors(status.getFieldValidationErrors(), errorMessages);
    }

    @Test
    public void convertToModelConversionFails() {
        this.bindAgeWithValidatorConverterValidator();
        this.ageField.setValue("abc");
        Assert.assertEquals((long)32L, (long)((Person)this.item).getAge());
        this.assertValidationErrors((BinderValidationStatus<Person>)this.binder.validate(), "Value must be a number");
    }

    @Test
    public void convertToModelNegativeAgeFailsOnIntegerValidator() {
        this.bindAgeWithValidatorConverterValidator();
        this.ageField.setValue("-5");
        Assert.assertEquals((long)32L, (long)((Person)this.item).getAge());
        this.assertValidationErrors((BinderValidationStatus<Person>)this.binder.validate(), "Value must be non-negative");
    }

    @Test
    public void convertDataToField() {
        this.bindAgeWithValidatorConverterValidator();
        ((Person)this.binder.getBean()).setAge(12);
        this.binder.readBean((Object)((Person)this.binder.getBean()));
        Assert.assertEquals((Object)"12", (Object)this.ageField.getValue());
    }

    @Test
    public void convertNotValidatableDataToField() {
        this.bindAgeWithValidatorConverterValidator();
        ((Person)this.binder.getBean()).setAge(-12);
        this.binder.readBean((Object)((Person)this.binder.getBean()));
        Assert.assertEquals((Object)"-12", (Object)this.ageField.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void convertInvalidDataToField() {
        TextField field = new TextField();
        StatusBean bean = new StatusBean();
        bean.setStatus("1");
        Binder binder = new Binder();
        Binder.BindingBuilder binding = binder.forField((HasValue)field).withConverter((SerializableFunction & Serializable)presentation -> {
            if (presentation.equals("OK")) {
                return "1";
            }
            if (presentation.equals("NOTOK")) {
                return "2";
            }
            throw new IllegalArgumentException("Value must be OK or NOTOK");
        }, (SerializableFunction & Serializable)model -> {
            if (model.equals("1")) {
                return "OK";
            }
            if (model.equals("2")) {
                return "NOTOK";
            }
            throw new IllegalArgumentException("Value in model must be 1 or 2");
        });
        binding.bind(StatusBean::getStatus, StatusBean::setStatus);
        binder.setBean((Object)bean);
        bean.setStatus("3");
        binder.readBean((Object)bean);
    }

    @Test
    public void validate_failedBeanValidatorWithoutFieldValidators() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        String msg = "foo";
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> false, (String)msg));
        Person person = new Person();
        this.binder.setBean((Object)person);
        List errors = this.binder.validate().getFieldValidationErrors();
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    @Test
    public void validate_failedBeanValidatorWithFieldValidator() {
        String msg = "foo";
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg));
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> false, (String)msg));
        Person person = new Person();
        this.binder.setBean((Object)person);
        List errors = this.binder.validate().getFieldValidationErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        BindingValidationStatus error = (BindingValidationStatus)errors.get(0);
        Assert.assertEquals((Object)msg, error.getMessage().get());
        Assert.assertEquals((Object)this.nameField, (Object)error.getField());
    }

    @Test
    public void validate_failedBothBeanValidatorAndFieldValidator() {
        String msg1 = "foo";
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg1));
        binding.bind(Person::getFirstName, Person::setFirstName);
        String msg2 = "bar";
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> false, (String)msg2));
        Person person = new Person();
        this.binder.setBean((Object)person);
        List errors = this.binder.validate().getFieldValidationErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        BindingValidationStatus error = (BindingValidationStatus)errors.get(0);
        Assert.assertEquals((Object)msg1, error.getMessage().get());
        Assert.assertEquals((Object)this.nameField, (Object)error.getField());
    }

    @Test
    public void validate_okBeanValidatorWithoutFieldValidators() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        String msg = "foo";
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> true, (String)msg));
        Person person = new Person();
        this.binder.setBean((Object)person);
        Assert.assertFalse((boolean)this.binder.validate().hasErrors());
        Assert.assertTrue((boolean)this.binder.validate().isOk());
    }

    @Test
    public void binder_saveIfValid() {
        String msg1 = "foo";
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg1));
        binding.bind(Person::getFirstName, Person::setFirstName);
        String beanValidatorErrorMessage = "bar";
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> false, (String)beanValidatorErrorMessage));
        Person person = new Person();
        String firstName = "first name";
        person.setFirstName(firstName);
        this.binder.readBean((Object)person);
        this.nameField.setValue("");
        Assert.assertFalse((boolean)this.binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)firstName, (Object)person.getFirstName());
        this.nameField.setValue("new name");
        Assert.assertFalse((boolean)this.binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)firstName, (Object)person.getFirstName());
    }

    @Test
    public void updateBoundField_bindingValdationFails_beanLevelValidationIsNotRun() {
        this.bindAgeWithValidatorConverterValidator();
        this.bindName();
        AtomicBoolean beanLevelValidationRun = new AtomicBoolean();
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> beanLevelValidationRun.getAndSet(true), (String)""));
        this.ageField.setValue("not a number");
        Assert.assertFalse((boolean)beanLevelValidationRun.get());
        this.nameField.setValue("foo");
        Assert.assertFalse((boolean)beanLevelValidationRun.get());
    }

    @Test
    public void updateBoundField_bindingValdationSuccess_beanLevelValidationIsRun() {
        this.bindAgeWithValidatorConverterValidator();
        this.bindName();
        AtomicBoolean beanLevelValidationRun = new AtomicBoolean();
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> beanLevelValidationRun.getAndSet(true), (String)""));
        this.ageField.setValue(String.valueOf(12));
        Assert.assertTrue((boolean)beanLevelValidationRun.get());
    }

    @Test
    public void binderHasChanges() throws ValidationException {
        this.binder.forField((HasValue)this.nameField).withValidator(Validator.from((SerializablePredicate & Serializable)name -> !"".equals(name), (String)"Name can't be empty")).bind(Person::getFirstName, Person::setFirstName);
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.binder.setBean((Object)((Person)this.item));
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.nameField.setValue("foo");
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.nameField.setValue("bar");
        this.binder.writeBeanIfValid((Object)new Person());
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.nameField.setValue("");
        this.binder.writeBeanIfValid((Object)new Person());
        Assert.assertTrue((boolean)this.binder.hasChanges());
        this.binder.readBean((Object)((Person)this.item));
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.nameField.setValue("");
        Assert.assertTrue((boolean)this.binder.hasChanges());
        this.binder.removeBean();
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.nameField.setValue("foo");
        Assert.assertTrue((boolean)this.binder.hasChanges());
        this.binder.writeBeanIfValid((Object)new Person());
        Assert.assertFalse((boolean)this.binder.hasChanges());
        this.nameField.setValue("");
        Assert.assertTrue((boolean)this.binder.hasChanges());
        this.nameField.setValue("");
        this.binder.writeBeanIfValid((Object)new Person());
        Assert.assertTrue((boolean)this.binder.hasChanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ValidationException.class)
    public void save_fieldValidationErrors() throws ValidationException {
        Binder binder = new Binder();
        String msg = "foo";
        binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg)).bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        String firstName = "foo";
        person.setFirstName(firstName);
        this.nameField.setValue("");
        try {
            binder.writeBean((Object)person);
        }
        finally {
            Assert.assertEquals((Object)firstName, (Object)person.getFirstName());
        }
    }

    @Test(expected=ValidationException.class)
    public void save_beanValidationErrors() throws ValidationException {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator("a")).bind(Person::getFirstName, Person::setFirstName);
        binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> false, (String)"b"));
        Person person2 = new Person();
        this.nameField.setValue("foo");
        try {
            binder.writeBean((Object)person2);
        }
        finally {
            Assert.assertNull((Object)person2.getFirstName());
        }
    }

    @Test
    public void save_fieldsAndBeanLevelValidation() throws ValidationException {
        this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator("a")).bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> person.getLastName() != null, (String)"b"));
        Person person2 = new Person();
        person2.setLastName("bar");
        this.nameField.setValue("foo");
        this.binder.writeBean((Object)person2);
        Assert.assertEquals((Object)this.nameField.getValue(), (Object)person2.getFirstName());
        Assert.assertEquals((Object)"bar", (Object)person2.getLastName());
    }

    @Test
    public void saveIfValid_fieldValidationErrors() {
        String msg = "foo";
        this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg)).bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("foo");
        this.nameField.setValue("");
        Assert.assertFalse((boolean)this.binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)"foo", (Object)person.getFirstName());
    }

    @Test
    public void saveIfValid_noValidationErrors() {
        String msg = "foo";
        this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg)).bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("foo");
        this.nameField.setValue("bar");
        Assert.assertTrue((boolean)this.binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)"bar", (Object)person.getFirstName());
    }

    @Test
    public void saveIfValid_beanValidationErrors() {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        String msg = "foo";
        binder.withValidator(Validator.from((SerializablePredicate & Serializable)prsn -> prsn.getAddress() != null || prsn.getEmail() != null, (String)msg));
        Person person = new Person();
        person.setFirstName("foo");
        this.nameField.setValue("");
        Assert.assertFalse((boolean)binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)"foo", (Object)person.getFirstName());
    }

    @Test
    public void save_null_beanIsUpdated() throws ValidationException {
        Binder binder = new Binder();
        binder.forField((HasValue)this.nameField).withConverter((SerializableFunction & Serializable)fieldValue -> {
            if ("null".equals(fieldValue)) {
                return null;
            }
            return fieldValue;
        }, (SerializableFunction & Serializable)model -> model).bind(Person::getFirstName, Person::setFirstName);
        Person person = new Person();
        person.setFirstName("foo");
        this.nameField.setValue("null");
        binder.writeBean((Object)person);
        Assert.assertNull((Object)person.getFirstName());
    }

    @Test
    public void save_validationErrors_exceptionContainsErrors() throws ValidationException {
        String msg = "foo";
        Binder.BindingBuilder nameBinding = this.binder.forField((HasValue)this.nameField).withValidator(new NotEmptyValidator(msg));
        nameBinding.bind(Person::getFirstName, Person::setFirstName);
        Binder.BindingBuilder ageBinding = this.binder.forField((HasValue)this.ageField).withConverter(this.stringToInteger).withValidator(this.notNegative);
        ageBinding.bind(Person::getAge, Person::setAge);
        Person person = new Person();
        this.nameField.setValue("");
        this.ageField.setValue("-1");
        try {
            this.binder.writeBean((Object)person);
            Assert.fail();
        }
        catch (ValidationException exception) {
            List validationErrors = exception.getFieldValidationErrors();
            Assert.assertEquals((long)2L, (long)validationErrors.size());
            BindingValidationStatus error = (BindingValidationStatus)validationErrors.get(0);
            Assert.assertEquals((Object)this.nameField, (Object)error.getField());
            Assert.assertEquals((Object)msg, error.getMessage().get());
            error = (BindingValidationStatus)validationErrors.get(1);
            Assert.assertEquals((Object)this.ageField, (Object)error.getField());
            Assert.assertEquals((Object)"Value must be non-negative", error.getMessage().get());
        }
    }

    @Test
    public void binderBindAndLoad_clearsErrors() {
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField).withValidator(this.notEmpty);
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> !bean.getFirstName().contains("error"), "error");
        Person person = new Person();
        person.setFirstName("");
        this.binder.setBean((Object)person);
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("foo");
        this.nameField.setValue("");
        Assert.assertNotNull((Object)this.nameField.getComponentError());
        person = new Person();
        person.setFirstName("");
        this.binder.setBean((Object)person);
        Assert.assertNull((Object)this.nameField.getComponentError());
        this.nameField.setValue("foo");
        this.nameField.setValue("");
        Assert.assertNotNull((Object)this.nameField.getComponentError());
        this.binder.readBean((Object)person);
        Assert.assertNull((Object)this.nameField.getComponentError());
        TextField lastNameField = new TextField();
        person.setLastName("bar");
        Binder.BindingBuilder binding2 = this.binder.forField((HasValue)lastNameField).withValidator(this.notEmpty);
        binding2.bind(Person::getLastName, Person::setLastName);
        Assert.assertNull((Object)lastNameField.getComponentError());
        lastNameField.setValue("");
        Assert.assertNotNull((Object)lastNameField.getComponentError());
        Label statusLabel = new Label();
        this.binder.setStatusLabel(statusLabel);
        this.nameField.setValue("error");
        Assert.assertEquals((Object)"", (Object)statusLabel.getValue());
        lastNameField.setValue("foo");
        Assert.assertEquals((Object)"error", (Object)statusLabel.getValue());
        this.binder.readBean((Object)person);
        Assert.assertEquals((Object)"", (Object)statusLabel.getValue());
        this.nameField.setValue("");
        lastNameField.setValue("");
        Assert.assertNotNull((Object)this.nameField.getComponentError());
        Assert.assertNotNull((Object)lastNameField.getComponentError());
        statusLabel.setComponentError((ErrorMessage)new UserError("ERROR"));
        this.binder.removeBean();
        Assert.assertNull((Object)this.nameField.getComponentError());
        Assert.assertNull((Object)lastNameField.getComponentError());
        Assert.assertEquals((Object)"", (Object)statusLabel.getValue());
    }

    @Test
    public void binderLoad_withCrossFieldValidation_clearsErrors() {
        TextField lastNameField = new TextField();
        SerializablePredicate & Serializable lengthPredicate = (SerializablePredicate & Serializable)v -> v.length() > 2;
        Binder.BindingBuilder firstNameBinding = this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate)lengthPredicate, "length");
        firstNameBinding.bind(Person::getFirstName, Person::setFirstName);
        Binder.Binding lastNameBinding = this.binder.forField((HasValue)lastNameField).withValidator((SerializablePredicate & Serializable)v -> !this.nameField.getValue().isEmpty() || lengthPredicate.test(v), "err").withValidator((SerializablePredicate)lengthPredicate, "length").bind(Person::getLastName, Person::setLastName);
        this.nameField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> lastNameBinding.validate());
        Person person = new Person();
        this.binder.setBean((Object)person);
        Assert.assertNull((Object)this.nameField.getComponentError());
        Assert.assertNull((Object)lastNameField.getComponentError());
        this.nameField.setValue("x");
        Assert.assertNotNull((Object)this.nameField.getComponentError());
        Assert.assertNotNull((Object)lastNameField.getComponentError());
        this.binder.setBean((Object)person);
        Assert.assertNull((Object)this.nameField.getComponentError());
        Assert.assertNull((Object)lastNameField.getComponentError());
    }

    protected void bindName() {
        this.binder.bind((HasValue)this.nameField, Person::getFirstName, Person::setFirstName);
        this.binder.setBean((Object)((Person)this.item));
    }

    protected void bindAgeWithValidatorConverterValidator() {
        this.binder.forField((HasValue)this.ageField).withValidator(this.notEmpty).withConverter(this.stringToInteger).withValidator(this.notNegative).bind(Person::getAge, Person::setAge);
        this.binder.setBean((Object)((Person)this.item));
    }

    @Test(expected=ValidationException.class)
    public void save_beanValidationErrorsWithConverter() throws ValidationException {
        Binder binder = new Binder();
        binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("Can't convert")).bind(Person::getAge, Person::setAge);
        binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> false, (String)"b"));
        Person person2 = new Person();
        this.ageField.setValue("1");
        try {
            binder.writeBean((Object)person2);
        }
        finally {
            Assert.assertEquals((long)0L, (long)person2.getAge());
        }
    }

    private static class StatusBean
    implements Serializable {
        private String status;

        private StatusBean() {
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

