/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.BinderValidationStatusHandler;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.data.BindingValidationStatusHandler;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.StatusChangeListener;
import com.vaadin.data.ValidationException;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.data.validator.EmailValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.Button;
import com.vaadin.ui.DateField;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Slider;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderBookOfVaadinTest {
    private Binder<BookPerson> binder;
    private TextField field;
    private TextField phoneField;
    private TextField emailField;

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.field = new TextField();
        this.phoneField = new TextField();
        this.emailField = new TextField();
        this.field.setLocale(Locale.US);
        this.phoneField.setLocale(Locale.US);
        this.emailField.setLocale(Locale.US);
    }

    @Test
    public void loadingFromBusinessObjects() {
        this.binder.readBean((Object)new BookPerson(1969, 50000));
        BinderValidationStatus status = this.binder.validate();
        if (status.hasErrors()) {
            Notification.show((String)("Validation error count: " + status.getValidationErrors().size()));
        }
    }

    @Test
    public void handlingCheckedException() {
        try {
            this.binder.writeBean((Object)new BookPerson(2000, 50000));
        }
        catch (ValidationException e) {
            Notification.show((String)("Validation error count: " + e.getValidationErrors().size()));
        }
    }

    @Test
    public void simpleEmailValidator() {
        this.binder.forField((HasValue)this.field).withValidator((Validator)new EmailValidator("This doesn't look like a valid email address")).bind(BookPerson::getEmail, BookPerson::setEmail);
        this.field.setValue("not-email");
        BinderValidationStatus status = this.binder.validate();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((Object)"This doesn't look like a valid email address", ((BindingValidationStatus)status.getFieldValidationErrors().get(0)).getMessage().get());
        Assert.assertEquals((Object)"This doesn't look like a valid email address", (Object)((AbstractErrorMessage)this.field.getErrorMessage()).getMessage());
        this.field.setValue("abc@vaadin.com");
        status = this.binder.validate();
        Assert.assertEquals((long)0L, (long)status.getBeanValidationErrors().size());
        Assert.assertNull((Object)this.field.getErrorMessage());
    }

    @Test
    public void nameLengthTest() {
        this.binder.forField((HasValue)this.field).withValidator((SerializablePredicate & Serializable)name -> name.length() >= 3, "Last name must contain at least three characters").bind(BookPerson::getLastName, BookPerson::setLastName);
        this.field.setValue("a");
        BinderValidationStatus status = this.binder.validate();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((Object)"Last name must contain at least three characters", ((BindingValidationStatus)status.getFieldValidationErrors().get(0)).getMessage().get());
        Assert.assertEquals((Object)"Last name must contain at least three characters", (Object)((AbstractErrorMessage)this.field.getErrorMessage()).getMessage());
        this.field.setValue("long last name");
        status = this.binder.validate();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertNull((Object)this.field.getErrorMessage());
    }

    @Test
    public void chainedEmailValidator() {
        this.binder.forField((HasValue)this.field).withValidator((Validator)new EmailValidator("This doesn't look like a valid email address")).withValidator((SerializablePredicate & Serializable)email -> email.endsWith("@acme.com"), "Only acme.com email addresses are allowed").bind(BookPerson::getEmail, BookPerson::setEmail);
        this.field.setValue("not-email");
        BinderValidationStatus status = this.binder.validate();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((Object)"This doesn't look like a valid email address", ((BindingValidationStatus)status.getFieldValidationErrors().get(0)).getMessage().get());
        Assert.assertEquals((Object)"This doesn't look like a valid email address", (Object)((AbstractErrorMessage)this.field.getErrorMessage()).getMessage());
        this.field.setValue("abc@vaadin.com");
        status = this.binder.validate();
        Assert.assertEquals((long)1L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((Object)"Only acme.com email addresses are allowed", ((BindingValidationStatus)status.getFieldValidationErrors().get(0)).getMessage().get());
        Assert.assertEquals((Object)"Only acme.com email addresses are allowed", (Object)((AbstractErrorMessage)this.field.getErrorMessage()).getMessage());
        this.field.setValue("abc@acme.com");
        status = this.binder.validate();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertNull((Object)this.field.getErrorMessage());
    }

    @Test
    public void converterBookOfVaadinExample1() {
        TextField yearOfBirthField = new TextField();
        yearOfBirthField.setLocale(Locale.US);
        Slider salaryLevelField = new Slider("Salary level", 1, 10);
        Binder.BindingBuilder b1 = this.binder.forField((HasValue)yearOfBirthField);
        Binder.BindingBuilder b2 = b1.withConverter((Converter)new StringToIntegerConverter("Must enter a number"));
        b2.bind(BookPerson::getYearOfBirth, BookPerson::setYearOfBirth);
        Binder.BindingBuilder salaryBinding1 = this.binder.forField((HasValue)salaryLevelField);
        Binder.BindingBuilder salaryBinding2 = salaryBinding1.withConverter(Double::intValue, Integer::doubleValue);
        salaryBinding2.bind(BookPerson::getSalaryLevel, BookPerson::setSalaryLevel);
        BookPerson bookPerson = new BookPerson(1972, 4);
        this.binder.setBean((Object)bookPerson);
        Assert.assertEquals((double)4.0, (double)salaryLevelField.getValue(), (double)0.0);
        Assert.assertEquals((Object)"1,972", (Object)yearOfBirthField.getValue());
        bookPerson.setSalaryLevel(8);
        this.binder.readBean((Object)bookPerson);
        Assert.assertEquals((double)8.0, (double)salaryLevelField.getValue(), (double)0.0);
        bookPerson.setYearOfBirth(123);
        this.binder.readBean((Object)bookPerson);
        Assert.assertEquals((Object)"123", (Object)yearOfBirthField.getValue());
        yearOfBirthField.setValue("2016");
        salaryLevelField.setValue(Double.valueOf(1.0));
        Assert.assertEquals((long)2016L, (long)bookPerson.getYearOfBirth());
        Assert.assertEquals((long)1L, (long)bookPerson.getSalaryLevel());
    }

    @Test
    public void converterBookOfVaadinExample2() {
        TextField yearOfBirthField = new TextField();
        this.binder.forField((HasValue)yearOfBirthField).withConverter(Integer::valueOf, String::valueOf, "Please enter a number").bind(BookPerson::getYearOfBirth, BookPerson::setYearOfBirth);
        this.binder.setBean((Object)new BookPerson(1900, 5));
        yearOfBirthField.setValue("abc");
        this.binder.validate();
        Assert.assertEquals((Object)"Please&#32;enter&#32;a&#32;number", (Object)yearOfBirthField.getComponentError().getFormattedHtmlMessage());
    }

    @Test
    public void crossFieldValidation_validateUsingBinder() {
        Binder binder = new Binder();
        DateField departing = new DateField("Departing");
        DateField returning = new DateField("Returning");
        Binder.Binding returnBinding = binder.forField((HasValue)returning).withValidator((SerializablePredicate & Serializable)returnDate -> !returnDate.isBefore((ChronoLocalDate)departing.getValue()), "Cannot return before departing").bind(Trip::getReturnDate, Trip::setReturnDate);
        departing.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> returnBinding.validate());
        LocalDate past = LocalDate.now();
        LocalDate before = past.plusDays(1L);
        LocalDate after = before.plusDays(1L);
        departing.setValue((Temporal)before);
        returning.setValue((Temporal)after);
        BinderValidationStatus status = binder.validate();
        Assert.assertTrue((boolean)status.getBeanValidationErrors().isEmpty());
        Assert.assertNull((Object)departing.getComponentError());
        Assert.assertNull((Object)returning.getComponentError());
        returning.setValue((Temporal)past);
        status = binder.validate();
        Assert.assertFalse((boolean)status.getFieldValidationErrors().isEmpty());
        Assert.assertNotNull((Object)returning.getComponentError());
        Assert.assertNull((Object)departing.getComponentError());
        returning.setValue((Temporal)before);
        status = binder.validate();
        Assert.assertTrue((boolean)status.getFieldValidationErrors().isEmpty());
        Assert.assertNull((Object)departing.getComponentError());
        Assert.assertNull((Object)returning.getComponentError());
        departing.setValue((Temporal)after);
        status = binder.validate();
        Assert.assertFalse((boolean)status.getFieldValidationErrors().isEmpty());
        Assert.assertNotNull((Object)returning.getComponentError());
        Assert.assertNull((Object)departing.getComponentError());
    }

    @Test
    public void crossFieldValidation_validateUsingBinding() {
        Binder binder = new Binder();
        DateField departing = new DateField("Departing");
        DateField returning = new DateField("Returning");
        Binder.Binding returnBinding = binder.forField((HasValue)returning).withValidator((SerializablePredicate & Serializable)returnDate -> !returnDate.isBefore((ChronoLocalDate)departing.getValue()), "Cannot return before departing").bind(Trip::getReturnDate, Trip::setReturnDate);
        departing.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> returnBinding.validate());
        LocalDate past = LocalDate.now();
        LocalDate before = past.plusDays(1L);
        LocalDate after = before.plusDays(1L);
        departing.setValue((Temporal)before);
        returning.setValue((Temporal)after);
        BindingValidationStatus result = returnBinding.validate();
        Assert.assertFalse((boolean)result.isError());
        Assert.assertNull((Object)departing.getComponentError());
        returning.setValue((Temporal)past);
        result = returnBinding.validate();
        Assert.assertTrue((boolean)result.isError());
        Assert.assertNotNull((Object)returning.getComponentError());
        returning.setValue((Temporal)before);
        result = returnBinding.validate();
        Assert.assertFalse((boolean)result.isError());
        Assert.assertNull((Object)departing.getComponentError());
        departing.setValue((Temporal)after);
        result = returnBinding.validate();
        Assert.assertTrue((boolean)result.isError());
        Assert.assertNotNull((Object)returning.getComponentError());
    }

    @Test
    public void withStatusLabelExample() {
        Label emailStatus = new Label();
        String msg = "This doesn't look like a valid email address";
        this.binder.forField((HasValue)this.field).withValidator((Validator)new EmailValidator(msg)).withStatusLabel(emailStatus).bind(BookPerson::getEmail, BookPerson::setEmail);
        this.field.setValue("foo");
        this.binder.validate();
        Assert.assertTrue((boolean)emailStatus.isVisible());
        Assert.assertEquals((Object)msg, (Object)emailStatus.getValue());
        this.field.setValue("foo@vaadin.com");
        this.binder.validate();
        Assert.assertFalse((boolean)emailStatus.isVisible());
        Assert.assertEquals((Object)"", (Object)emailStatus.getValue());
    }

    @Test
    public void withBindingStatusHandlerExample() {
        Label nameStatus = new Label();
        AtomicReference statusCapture = new AtomicReference();
        String msg = "Full name must contain at least three characters";
        this.binder.forField((HasValue)this.field).withValidator((SerializablePredicate & Serializable)name -> name.length() >= 3, msg).withValidationStatusHandler((BindingValidationStatusHandler & Serializable)status -> {
            nameStatus.setValue(status.getMessage().orElse(""));
            boolean error = status.getStatus() == BindingValidationStatus.Status.ERROR;
            nameStatus.setVisible(error);
            statusCapture.set(status);
        }).bind(BookPerson::getLastName, BookPerson::setLastName);
        this.field.setValue("aa");
        this.binder.validate();
        Assert.assertTrue((boolean)nameStatus.isVisible());
        Assert.assertEquals((Object)msg, (Object)nameStatus.getValue());
        Assert.assertNotNull(statusCapture.get());
        BindingValidationStatus status2 = (BindingValidationStatus)statusCapture.get();
        Assert.assertEquals((Object)BindingValidationStatus.Status.ERROR, (Object)status2.getStatus());
        Assert.assertEquals((Object)msg, status2.getMessage().get());
        Assert.assertEquals((Object)this.field, (Object)status2.getField());
        this.field.setValue("foo");
        this.binder.validate();
        Assert.assertFalse((boolean)nameStatus.isVisible());
        Assert.assertEquals((Object)"", (Object)nameStatus.getValue());
        Assert.assertNotNull(statusCapture.get());
        status2 = (BindingValidationStatus)statusCapture.get();
        Assert.assertEquals((Object)BindingValidationStatus.Status.OK, (Object)status2.getStatus());
        Assert.assertFalse((boolean)status2.getMessage().isPresent());
        Assert.assertEquals((Object)this.field, (Object)status2.getField());
    }

    @Test
    public void binder_saveIfValid() {
        Binder binder = new Binder(BookPerson.class);
        Validator phoneOrEmail = Validator.from((SerializablePredicate & Serializable)personBean -> !"".equals(personBean.getPhone()) || !"".equals(personBean.getEmail()), (String)"A person must have either a phone number or an email address");
        binder.withValidator(phoneOrEmail);
        binder.forField((HasValue)this.emailField).bind("email");
        binder.forField((HasValue)this.phoneField).bind("phone");
        BookPerson person = new BookPerson(1900, 5);
        person.setEmail("Old Email");
        binder.readBean((Object)person);
        Button saveButton = new Button("Save", (Button.ClickListener & Serializable)event -> {
            if (binder.writeBeanIfValid((Object)person)) {
                // empty if block
            }
        });
        this.emailField.setValue("foo@bar.com");
        Assert.assertTrue((boolean)binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)"foo@bar.com", (Object)person.getEmail());
        this.emailField.setValue("");
        Assert.assertFalse((boolean)binder.writeBeanIfValid((Object)person));
        Assert.assertEquals((Object)"foo@bar.com", (Object)person.getEmail());
    }

    @Test
    public void manyConvertersAndValidators() throws ValidationException {
        TextField yearOfBirthField = new TextField();
        this.binder.forField((HasValue)yearOfBirthField).withValidator((SerializablePredicate & Serializable)text -> text.length() == 4, "Doesn't look like a year").withConverter((Converter)new StringToIntegerConverter("Must enter a number")).withValidator((SerializablePredicate & Serializable)year -> year >= 1900 && year <= 2000, "Person must be born in the 20th century").bind(BookPerson::getYearOfBirth, BookPerson::setYearOfBirth);
        yearOfBirthField.setValue("abc");
        Assert.assertEquals((Object)"Doesn't look like a year", ((BindingValidationStatus)this.binder.validate().getFieldValidationErrors().get(0)).getMessage().get());
        yearOfBirthField.setValue("abcd");
        Assert.assertEquals((Object)"Must enter a number", ((BindingValidationStatus)this.binder.validate().getFieldValidationErrors().get(0)).getMessage().get());
        yearOfBirthField.setValue("1200");
        Assert.assertEquals((Object)"Person must be born in the 20th century", ((BindingValidationStatus)this.binder.validate().getFieldValidationErrors().get(0)).getMessage().get());
        yearOfBirthField.setValue("1950");
        Assert.assertFalse((boolean)this.binder.validate().hasErrors());
        BookPerson person = new BookPerson(1500, 12);
        this.binder.writeBean((Object)person);
        Assert.assertEquals((long)1950L, (long)person.getYearOfBirth());
    }

    @Test
    public void bindUsingCustomConverter() {
        Binder binder = new Binder();
        TextField yearOfBirthField = new TextField();
        binder.forField((HasValue)yearOfBirthField).withConverter((Converter)new MyConverter()).bind(BookPerson::getYearOfBirth, BookPerson::setYearOfBirth);
        BookPerson p = new BookPerson(1500, 12);
        binder.setBean((Object)p);
        yearOfBirthField.setValue("abc");
        Assert.assertTrue((boolean)binder.validate().hasErrors());
        Assert.assertEquals((Object)"Please enter a number", ((BindingValidationStatus)binder.validate().getFieldValidationErrors().get(0)).getMessage().get());
        yearOfBirthField.setValue("123");
        Assert.assertTrue((boolean)binder.validate().isOk());
        p.setYearOfBirth(12500);
        binder.readBean((Object)p);
        Assert.assertEquals((Object)"12500", (Object)yearOfBirthField.getValue());
        Assert.assertTrue((boolean)binder.validate().isOk());
    }

    @Test
    public void withBinderStatusLabelExample() {
        Label formStatusLabel = new Label();
        Binder binder = new Binder(BookPerson.class);
        binder.setStatusLabel(formStatusLabel);
        String message = "Too young, son";
        String message2 = "Y2K error";
        TextField yearOfBirth = new TextField();
        BookPerson p = new BookPerson(1500, 12);
        binder.forField((HasValue)yearOfBirth).withConverter((Converter)new StringToIntegerConverter("err")).bind(BookPerson::getYearOfBirth, BookPerson::setYearOfBirth);
        binder.withValidator((SerializablePredicate & Serializable)bean -> ((BookPerson)bean).yearOfBirth < 2000, "Too young, son").withValidator((SerializablePredicate & Serializable)bean -> ((BookPerson)bean).yearOfBirth != 2000, "Y2K error");
        binder.setBean((Object)p);
        yearOfBirth.setValue("2001");
        BinderValidationStatus status = binder.validate();
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)1L, (long)status.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"Too young, son", (Object)((ValidationResult)status.getBeanValidationErrors().get(0)).getErrorMessage());
        Assert.assertEquals((Object)"Too young, son", (Object)formStatusLabel.getValue());
        yearOfBirth.setValue("1999");
        status = binder.validate();
        Assert.assertFalse((boolean)status.hasErrors());
        Assert.assertEquals((Object)"", (Object)formStatusLabel.getValue());
        yearOfBirth.setValue("2000");
        status = binder.validate();
        Assert.assertEquals((long)2L, (long)status.getBeanValidationResults().size());
        Assert.assertEquals((long)0L, (long)status.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)status.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"Too young, son", (Object)formStatusLabel.getValue());
    }

    @Test
    public void withBinderStatusHandlerExample() {
        Label formStatusLabel = new Label();
        BinderValidationStatusHandler defaultHandler = this.binder.getValidationStatusHandler();
        this.binder.setValidationStatusHandler((BinderValidationStatusHandler & Serializable)status -> {
            List errors = status.getBeanValidationErrors();
            String errorMessage = errors.stream().map(ValidationResult::getErrorMessage).collect(Collectors.joining("\n"));
            formStatusLabel.setValue(errorMessage);
            formStatusLabel.setVisible(!errorMessage.isEmpty());
            defaultHandler.statusChange(status);
        });
        String bindingMessage = "uneven";
        String message = "Too young, son";
        String message2 = "Y2K error";
        TextField yearOfBirth = new TextField();
        BookPerson p = new BookPerson(1500, 12);
        this.binder.forField((HasValue)yearOfBirth).withConverter((Converter)new StringToIntegerConverter("err")).withValidator((SerializablePredicate & Serializable)value -> value % 2 == 0, "uneven").bind(BookPerson::getYearOfBirth, BookPerson::setYearOfBirth);
        this.binder.withValidator((SerializablePredicate & Serializable)bean -> ((BookPerson)bean).yearOfBirth < 2000, "Too young, son").withValidator((SerializablePredicate & Serializable)bean -> ((BookPerson)bean).yearOfBirth != 2000, "Y2K error");
        this.binder.setBean((Object)p);
        yearOfBirth.setValue("2001");
        BinderValidationStatus status2 = this.binder.validate();
        Assert.assertEquals((long)1L, (long)status2.getFieldValidationErrors().size());
        Assert.assertEquals((Object)"uneven", ((BindingValidationStatus)status2.getFieldValidationErrors().get(0)).getMessage().get());
        Assert.assertEquals((Object)"", (Object)formStatusLabel.getValue());
        yearOfBirth.setValue("2002");
        status2 = this.binder.validate();
        Assert.assertEquals((long)0L, (long)status2.getFieldValidationErrors().size());
        Assert.assertEquals((long)1L, (long)status2.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"Too young, son", (Object)((ValidationResult)status2.getBeanValidationErrors().get(0)).getErrorMessage());
        Assert.assertEquals((Object)"Too young, son", (Object)formStatusLabel.getValue());
        yearOfBirth.setValue("1998");
        status2 = this.binder.validate();
        Assert.assertTrue((boolean)status2.isOk());
        Assert.assertFalse((boolean)status2.hasErrors());
        Assert.assertEquals((long)0L, (long)status2.getFieldValidationErrors().size());
        Assert.assertEquals((long)0L, (long)status2.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"", (Object)formStatusLabel.getValue());
        yearOfBirth.setValue("2000");
        status2 = this.binder.validate();
        Assert.assertEquals((long)0L, (long)status2.getFieldValidationErrors().size());
        Assert.assertEquals((long)2L, (long)status2.getBeanValidationErrors().size());
        Assert.assertEquals((Object)"Too young, son\nY2K error", (Object)formStatusLabel.getValue());
    }

    @Test
    public void statusChangeListener_binderIsNotBound() {
        Button saveButton = new Button();
        Button resetButton = new Button();
        AtomicBoolean eventIsFired = new AtomicBoolean(false);
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)event -> {
            boolean isValid = event.getBinder().isValid();
            boolean hasChanges = event.getBinder().hasChanges();
            eventIsFired.set(true);
            saveButton.setEnabled(hasChanges && isValid);
            resetButton.setEnabled(hasChanges);
        });
        this.binder.forField((HasValue)this.field).withValidator((Validator)new StringLengthValidator("", Integer.valueOf(1), Integer.valueOf(3))).bind(BookPerson::getLastName, BookPerson::setLastName);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        BookPerson person = new BookPerson(2000, 1);
        this.binder.readBean((Object)person);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        this.field.setValue("a");
        Assert.assertTrue((boolean)saveButton.isEnabled());
        Assert.assertTrue((boolean)resetButton.isEnabled());
        Assert.assertTrue((boolean)eventIsFired.get());
        this.binder.writeBeanIfValid((Object)person);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        this.binder.validate();
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        this.field.setValue("");
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertTrue((boolean)resetButton.isEnabled());
        Assert.assertTrue((boolean)eventIsFired.get());
    }

    @Test
    public void statusChangeListener_binderIsBound() {
        Button saveButton = new Button();
        Button resetButton = new Button();
        AtomicBoolean eventIsFired = new AtomicBoolean(false);
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)event -> {
            boolean isValid = event.getBinder().isValid();
            boolean hasChanges = event.getBinder().hasChanges();
            eventIsFired.set(true);
            saveButton.setEnabled(hasChanges && isValid);
            resetButton.setEnabled(hasChanges);
        });
        this.binder.forField((HasValue)this.field).withValidator((Validator)new StringLengthValidator("", Integer.valueOf(1), Integer.valueOf(3))).bind(BookPerson::getLastName, BookPerson::setLastName);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        BookPerson person = new BookPerson(2000, 1);
        this.binder.setBean((Object)person);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        this.field.setValue("a");
        this.verifyEventIsFired(eventIsFired);
        this.field.setValue("");
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertTrue((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
        this.field.setValue("a");
        this.verifyEventIsFired(eventIsFired);
        this.binder.writeBeanIfValid((Object)person);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        Assert.assertFalse((boolean)resetButton.isEnabled());
        this.verifyEventIsFired(eventIsFired);
    }

    @Test
    public void statusChangeListener_multipleRequiredFields() {
        Button saveButton = new Button();
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)event -> {
            boolean isValid = event.getBinder().isValid();
            boolean hasChanges = event.getBinder().hasChanges();
            saveButton.setEnabled(hasChanges && isValid);
        });
        this.binder.forField((HasValue)this.field).asRequired("").bind(BookPerson::getLastName, BookPerson::setLastName);
        this.binder.forField((HasValue)this.emailField).asRequired("").bind(BookPerson::getEmail, BookPerson::setEmail);
        Assert.assertFalse((boolean)saveButton.isEnabled());
        this.field.setValue("not empty");
        Assert.assertFalse((boolean)saveButton.isEnabled());
        this.emailField.setValue("not empty");
        Assert.assertTrue((boolean)saveButton.isEnabled());
        this.field.clear();
        Assert.assertFalse((boolean)saveButton.isEnabled());
    }

    @Test
    public void writeBean_throwsValidationException_bookExampleShouldCompile() {
        BookPerson person = new BookPerson("John Doe", 1957);
        this.binder.readBean((Object)person);
        Button saveButton = new Button("Save", (Button.ClickListener & Serializable)event -> {
            try {
                this.binder.writeBean((Object)person);
            }
            catch (ValidationException e) {
                Notification.show((String)"Person could not be saved, please check error messages for each field.");
            }
        });
        Button resetButton = new Button("Reset", (Button.ClickListener & Serializable)event -> this.binder.readBean((Object)person));
    }

    private void verifyEventIsFired(AtomicBoolean flag) {
        Assert.assertTrue((boolean)flag.get());
        flag.set(false);
    }

    class MyConverter
    implements Converter<String, Integer> {
        MyConverter() {
        }

        public Result<Integer> convertToModel(String fieldValue, ValueContext context) {
            try {
                return Result.ok((Object)Integer.valueOf(fieldValue));
            }
            catch (NumberFormatException e) {
                return Result.error((String)"Please enter a number");
            }
        }

        public String convertToPresentation(Integer integer, ValueContext context) {
            return String.valueOf(integer);
        }
    }

    public static class Trip {
        private LocalDate returnDate;

        public LocalDate getReturnDate() {
            return this.returnDate;
        }

        public void setReturnDate(LocalDate returnDate) {
            this.returnDate = returnDate;
        }
    }

    private static class BookPerson {
        private String lastName;
        private String email;
        private String phone;
        private String title;
        private int yearOfBirth;
        private int salaryLevel;

        public BookPerson(int yearOfBirth, int salaryLevel) {
            this.yearOfBirth = yearOfBirth;
            this.salaryLevel = salaryLevel;
        }

        public BookPerson(BookPerson origin) {
            this(origin.yearOfBirth, origin.salaryLevel);
            this.lastName = origin.lastName;
            this.email = origin.email;
            this.phone = origin.phone;
            this.title = origin.title;
        }

        public BookPerson(String name, int yearOfBirth) {
            this.lastName = name;
            this.yearOfBirth = yearOfBirth;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public int getYearOfBirth() {
            return this.yearOfBirth;
        }

        public void setYearOfBirth(int yearOfBirth) {
            this.yearOfBirth = yearOfBirth;
        }

        public int getSalaryLevel() {
            return this.salaryLevel;
        }

        public void setSalaryLevel(int salaryLevel) {
            this.salaryLevel = salaryLevel;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

