/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import com.vaadin.server.Resource;
import com.vaadin.server.SerializableFunction;

/**
 * A callback interface for generating icons for an item.
 *
 * @param <T>
 *            item type for which the icon is generated
 * @since 8.0
 */
@FunctionalInterface
public interface IconGenerator<T> extends SerializableFunction<T, Resource> {

    /**
     * Gets an icon resource for the {@code item}.
     *
     * @param item
     *            the item for which to generate an icon for
     * @return the generated icon resource
     */
    @Override
    public Resource apply(T item);
}
