/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import java.util.HashMap;
import java.util.Map;

/**
 * Item caption generator class for declarative support.
 * <p>
 * Provides a straightforward mapping between an item and its caption.
 *
 * @param <T>
 *            item type
 */
class DeclarativeCaptionGenerator<T> implements ItemCaptionGenerator<T> {

    private ItemCaptionGenerator<T> fallback;
    private Map<T, String> captions = new HashMap<>();

    public DeclarativeCaptionGenerator(ItemCaptionGenerator<T> fallback) {
        this.fallback = fallback;
    }

    @Override
    public String apply(T item) {
        return captions.containsKey(item) ? captions.get(item)
                : fallback.apply(item);
    }

    /**
     * Sets a {@code caption} for the {@code item}.
     *
     * @param item
     *            a data item
     * @param caption
     *            a caption for the {@code item}
     */
    protected void setCaption(T item, String caption) {
        captions.put(item, caption);
    }

}
