/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.data.converter;

import java.util.Date;

import com.vaadin.data.Converter;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;

/**
 * Converter for handling conversion between {@link java.util.Date} and
 * {@link java.sql.Date}. This is used when a PopupDateField or InlineDateField
 * is connected to a java.sql.Date property. Note that information (time
 * information) is lost when converting from {@link java.util.Date} to
 * {@link java.sql.Date}.
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
public class DateToSqlDateConverter implements Converter<Date, java.sql.Date> {

    @Override
    public Result<java.sql.Date> convertToModel(Date value,
            ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }

        return Result.ok(new java.sql.Date(value.getTime()));
    }

    @Override
    public Date convertToPresentation(java.sql.Date value,
            ValueContext context) {
        if (value == null) {
            return null;
        }

        return new Date(value.getTime());
    }

}
