/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.util;

import com.vaadin.server.DefaultDeploymentConfiguration;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import com.vaadin.util.CurrentInstanceFallbackResolver;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CurrentInstanceTest {
    @Before
    public void clearExistingThreadLocals() {
        CurrentInstance.clearAll();
    }

    @Before
    @After
    public void clearExistingFallbackResolvers() throws Exception {
        Field field = CurrentInstance.class.getDeclaredField("fallbackResolvers");
        field.setAccessible(true);
        Map map = (Map)field.get(null);
        map.clear();
    }

    @Test
    public void testInitiallyCleared() throws Exception {
        this.assertCleared();
    }

    @Test
    public void testClearedAfterRemove() throws Exception {
        CurrentInstance.set(CurrentInstanceTest.class, (Object)this);
        Assert.assertEquals((Object)this, (Object)CurrentInstance.get(CurrentInstanceTest.class));
        CurrentInstance.set(CurrentInstanceTest.class, null);
        this.assertCleared();
    }

    @Test
    public void testClearedWithClearAll() throws Exception {
        CurrentInstance.set(CurrentInstanceTest.class, (Object)this);
        Assert.assertEquals((Object)this, (Object)CurrentInstance.get(CurrentInstanceTest.class));
        CurrentInstance.clearAll();
        this.assertCleared();
    }

    private void assertCleared() throws SecurityException, NoSuchFieldException, IllegalAccessException {
        Assert.assertNull(this.getInternalCurrentInstanceVariable().get());
    }

    private ThreadLocal<Map<Class<?>, CurrentInstance>> getInternalCurrentInstanceVariable() throws SecurityException, NoSuchFieldException, IllegalAccessException {
        Field f = CurrentInstance.class.getDeclaredField("INSTANCES");
        f.setAccessible(true);
        return (ThreadLocal)f.get(null);
    }

    public void testInheritedClearedAfterRemove() {
    }

    @Test
    public void testRestoringNullUIWorks() throws Exception {
        CurrentInstance.clearAll();
        Map old = CurrentInstance.setCurrent((UI)new UIStoredInCurrentInstance());
        CurrentInstance.restoreInstances((Map)old);
        Assert.assertNull((Object)CurrentInstance.get(UI.class));
    }

    @Test
    public void testRestoringNullSessionWorks() throws Exception {
        CurrentInstance.clearAll();
        Map old = CurrentInstance.setCurrent((VaadinSession)new SessionStoredInCurrentInstance((VaadinService)EasyMock.createNiceMock(VaadinService.class)));
        CurrentInstance.restoreInstances((Map)old);
        Assert.assertNull((Object)CurrentInstance.get(VaadinSession.class));
        Assert.assertNull((Object)CurrentInstance.get(VaadinService.class));
    }

    @Test
    public void testRestoreWithGarbageCollectedValue() throws InterruptedException {
        VaadinSession session1 = new VaadinSession(null){

            public String toString() {
                return "First session";
            }
        };
        VaadinSession session2 = new VaadinSession(null){

            public String toString() {
                return "Second session";
            }
        };
        VaadinSession.setCurrent((VaadinSession)session1);
        Map previous = CurrentInstance.setCurrent((VaadinSession)session2);
        WeakReference<1> ref = new WeakReference<1>(session1);
        session1 = null;
        CurrentInstanceTest.waitUntilGarbageCollected(ref);
        CurrentInstance.restoreInstances((Map)previous);
        Assert.assertNull((Object)VaadinSession.getCurrent());
    }

    @Test
    public void testFallbackResolvers() throws Exception {
        TestFallbackResolver<FakeUI> uiResolver = new TestFallbackResolver<FakeUI>(new FakeUI());
        CurrentInstance.defineFallbackResolver(UI.class, uiResolver);
        TestFallbackResolver<FakeSession> sessionResolver = new TestFallbackResolver<FakeSession>(new FakeSession());
        CurrentInstance.defineFallbackResolver(VaadinSession.class, sessionResolver);
        TestFallbackResolver<FakeService> serviceResolver = new TestFallbackResolver<FakeService>(new FakeService(new FakeServlet()));
        CurrentInstance.defineFallbackResolver(VaadinService.class, serviceResolver);
        Assert.assertThat((Object)UI.getCurrent(), (Matcher)CoreMatchers.instanceOf(FakeUI.class));
        Assert.assertThat((Object)VaadinSession.getCurrent(), (Matcher)CoreMatchers.instanceOf(FakeSession.class));
        Assert.assertThat((Object)VaadinService.getCurrent(), (Matcher)CoreMatchers.instanceOf(FakeService.class));
        Assert.assertEquals((String)"The UI fallback resolver should have been called exactly once", (long)1L, (long)uiResolver.getCalled());
        Assert.assertEquals((String)"The VaadinSession fallback resolver should have been called exactly once", (long)1L, (long)sessionResolver.getCalled());
        Assert.assertEquals((String)"The VaadinService fallback resolver should have been called exactly once", (long)1L, (long)serviceResolver.getCalled());
        Assert.assertThat((Object)VaadinServlet.getCurrent(), (Matcher)CoreMatchers.instanceOf(FakeServlet.class));
        Assert.assertEquals((String)"The VaadinService fallback resolver should have been called exactly twice", (long)2L, (long)serviceResolver.getCalled());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFallbackResolversWithAlreadyDefinedResolver() {
        TestFallbackResolver<FakeUI> uiResolver = new TestFallbackResolver<FakeUI>(new FakeUI());
        CurrentInstance.defineFallbackResolver(UI.class, uiResolver);
        CurrentInstance.defineFallbackResolver(UI.class, uiResolver);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFallbackResolversWithNullResolver() {
        CurrentInstance.defineFallbackResolver(UI.class, null);
    }

    public static void waitUntilGarbageCollected(WeakReference<?> ref) throws InterruptedException {
        for (int i = 0; i < 50; ++i) {
            System.gc();
            if (ref.get() == null) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)"Value was not garbage collected.");
    }

    @Test
    public void nonInheritableThreadLocals() throws InterruptedException, ExecutionException {
        CurrentInstance.clearAll();
        CurrentInstance.set(CurrentInstanceTest.class, (Object)this);
        Assert.assertNotNull((Object)CurrentInstance.get(CurrentInstanceTest.class));
        Callable<Void> runnable = () -> {
            Assert.assertNull((Object)CurrentInstance.get(CurrentInstanceTest.class));
            return null;
        };
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<Void> future = service.submit(runnable);
        future.get();
    }

    private static class FakeSession
    extends VaadinSession {
        public FakeSession() {
            super(null);
        }
    }

    private static class FakeService
    extends VaadinServletService {
        public FakeService(VaadinServlet servlet) throws ServiceException {
            super(servlet, (DeploymentConfiguration)new DefaultDeploymentConfiguration(FakeService.class, new Properties()));
        }
    }

    private static class FakeServlet
    extends VaadinServlet {
        private FakeServlet() {
        }
    }

    private static class FakeUI
    extends UI {
        private FakeUI() {
        }

        protected void init(VaadinRequest request) {
        }
    }

    private static class TestFallbackResolver<T>
    implements CurrentInstanceFallbackResolver<T> {
        private int called;
        private final T instance;

        public TestFallbackResolver(T instance) {
            this.instance = instance;
        }

        public T resolve() {
            ++this.called;
            return this.instance;
        }

        public int getCalled() {
            return this.called;
        }
    }

    private static class SessionStoredInCurrentInstance
    extends VaadinSession {
        public SessionStoredInCurrentInstance(VaadinService service) {
            super(service);
        }
    }

    private static class UIStoredInCurrentInstance
    extends UI {
        private UIStoredInCurrentInstance() {
        }

        protected void init(VaadinRequest request) {
        }
    }
}

