/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.util.Locale;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class UIThemeEscapingTest {
    private UI ui;

    private void initUiWithTheme(String theme) {
        VaadinRequest request = this.getRequestWithTheme(theme);
        IMocksControl control = EasyMock.createNiceControl();
        VaadinSession session = (VaadinSession)control.createMock(VaadinSession.class);
        DeploymentConfiguration dc = (DeploymentConfiguration)control.createMock(DeploymentConfiguration.class);
        EasyMock.expect((Object)session.hasLock()).andStubReturn((Object)true);
        EasyMock.expect((Object)session.getConfiguration()).andStubReturn((Object)dc);
        EasyMock.expect((Object)session.getLocale()).andStubReturn((Object)Locale.getDefault());
        control.replay();
        this.ui.setSession(session);
        this.ui.getPage().init(request);
        this.ui.doInit(request, 1234, "foobar");
    }

    private VaadinRequest getRequestWithTheme(String theme) {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getParameter("theme")).thenReturn((Object)theme);
        Mockito.when((Object)request.getParameter("v-loc")).thenReturn((Object)"http://localhost/");
        return request;
    }

    @Before
    public void setup() {
        this.ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
    }

    @Test
    public void dangerousCharactersAreRemoved() {
        this.ui.setTheme("a<\u00e5(_\"$");
        MatcherAssert.assertThat((Object)this.ui.getTheme(), (Matcher)CoreMatchers.is((Object)"a\u00e5_$"));
    }

    @Test
    public void nullThemeIsSet() {
        this.ui.setTheme("foobar");
        this.ui.setTheme(null);
        MatcherAssert.assertThat((Object)this.ui.getTheme(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void themeIsSetOnInit() {
        this.ui.setTheme("foobar");
        this.initUiWithTheme("bar");
        MatcherAssert.assertThat((Object)this.ui.getTheme(), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void nullThemeIsSetOnInit() {
        this.ui.setTheme("foobar");
        this.initUiWithTheme(null);
        MatcherAssert.assertThat((Object)this.ui.getTheme(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

