/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.ClientConnector;
import com.vaadin.server.DefaultDeploymentConfiguration;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.MockServletConfig;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.communication.PushConnection;
import com.vaadin.shared.communication.PushMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.util.CurrentInstanceTest;
import java.lang.ref.WeakReference;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class UITest {
    @Test
    public void removeFromSessionWithExternalLock() throws Exception {
        UI ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
        final ReentrantLock externalLock = new ReentrantLock();
        MockServletConfig servletConfig = new MockServletConfig();
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)servletConfig);
        DefaultDeploymentConfiguration deploymentConfiguration = new DefaultDeploymentConfiguration(UI.class, new Properties());
        MockVaadinSession session = new MockVaadinSession((VaadinService)new VaadinServletService(servlet, (DeploymentConfiguration)deploymentConfiguration));
        session.lock();
        ui.setSession((VaadinSession)session);
        ui.getPushConfiguration().setPushMode(PushMode.MANUAL);
        ui.setPushConnection(new PushConnection(){
            private boolean connected = true;

            public void push() {
            }

            public boolean isConnected() {
                return this.connected;
            }

            public void disconnect() {
                externalLock.lock();
                try {
                    this.connected = false;
                }
                finally {
                    externalLock.unlock();
                }
            }
        });
        session.unlock();
        CountDownLatch websocketReachedCheckpoint = new CountDownLatch(1);
        CountDownLatch uiDisconnectReachedCheckpoint = new CountDownLatch(1);
        VaadinSession uiSession = ui.getSession();
        ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        Runnable websocketClose = () -> {
            externalLock.lock();
            websocketReachedCheckpoint.countDown();
            try {
                uiDisconnectReachedCheckpoint.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                exceptions.add(e);
                return;
            }
            uiSession.lock();
            externalLock.unlock();
        };
        Runnable disconnectPushFromUI = () -> {
            uiSession.lock();
            uiDisconnectReachedCheckpoint.countDown();
            try {
                websocketReachedCheckpoint.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                exceptions.add(e);
                return;
            }
            ui.setSession(null);
            uiSession.unlock();
        };
        Thread websocketThread = new Thread(websocketClose);
        websocketThread.start();
        Thread uiDisconnectThread = new Thread(disconnectPushFromUI);
        uiDisconnectThread.start();
        websocketThread.join(5000L);
        uiDisconnectThread.join(5000L);
        if (websocketThread.isAlive() || uiDisconnectThread.isAlive()) {
            websocketThread.interrupt();
            uiDisconnectThread.interrupt();
            Assert.fail((String)"Threads are still running");
        }
        if (!exceptions.isEmpty()) {
            for (Exception e : exceptions) {
                e.printStackTrace();
            }
            Assert.fail((String)"There were exceptions in the threads");
        }
        Assert.assertNull((Object)ui.getSession());
        for (int i = 0; i < 10 && ui.getPushConnection() != null; ++i) {
            Thread.sleep(500L);
        }
        Assert.assertNull((Object)ui.getPushConnection());
    }

    @Test
    public void connectorTrackerMemoryLeak() throws Exception {
        UI ui = new UI(){

            protected void init(VaadinRequest request) {
            }
        };
        MockServletConfig servletConfig = new MockServletConfig();
        VaadinServlet servlet = new VaadinServlet();
        servlet.init((ServletConfig)servletConfig);
        DefaultDeploymentConfiguration deploymentConfiguration = new DefaultDeploymentConfiguration(UI.class, new Properties());
        VaadinServletService service = new VaadinServletService(servlet, (DeploymentConfiguration)deploymentConfiguration);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        ui.setSession((VaadinSession)session);
        ui.getPushConfiguration().setPushMode(PushMode.AUTOMATIC);
        ui.doInit((VaadinRequest)Mockito.mock(VaadinRequest.class), 1, "foo");
        session.addUI(ui);
        ui.setContent(this.createContent());
        WeakReference<Component> contentSentToClient = new WeakReference<Component>(ui.getContent());
        ui.getConnectorTracker().markClientSideInitialized((ClientConnector)contentSentToClient.get());
        session.unlock();
        session.lock();
        ui.setContent(this.createContent());
        WeakReference<Component> contentOnlyOnServer = new WeakReference<Component>(ui.getContent());
        ui.setContent(this.createContent());
        CurrentInstanceTest.waitUntilGarbageCollected(contentOnlyOnServer);
        Assert.assertNotNull(contentSentToClient.get());
        session.unlock();
        CurrentInstanceTest.waitUntilGarbageCollected(contentSentToClient);
    }

    private Component createContent() {
        VerticalLayout vl = new VerticalLayout();
        vl.addComponent((Component)new Button("foo"));
        vl.addComponent((Component)new Button("bar"));
        vl.addComponent((Component)new Button("baz"));
        return vl;
    }
}

