/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractSplitPanel;
import com.vaadin.ui.HorizontalSplitPanel;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SplitPositionChangeListenerTest {
    @Test
    public void testSplitPositionListenerIsTriggered() throws Exception {
        HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();
        AbstractSplitPanel.SplitPositionChangeListener splitPositionChangeListener = (AbstractSplitPanel.SplitPositionChangeListener)Mockito.mock(AbstractSplitPanel.SplitPositionChangeListener.class);
        splitPanel.addSplitPositionChangeListener(splitPositionChangeListener);
        splitPanel.setSplitPosition(50.0f, Sizeable.Unit.PERCENTAGE);
        ((AbstractSplitPanel.SplitPositionChangeListener)Mockito.verify((Object)splitPositionChangeListener)).onSplitPositionChanged((AbstractSplitPanel.SplitPositionChangeEvent)Matchers.any(AbstractSplitPanel.SplitPositionChangeEvent.class));
    }

    @Test
    public void testSplitPositionListenerContainsOldValues() throws Exception {
        HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();
        float previousPosition = 50.0f;
        float newPosition = 125.0f;
        AtomicBoolean executed = new AtomicBoolean(false);
        splitPanel.setSplitPosition(previousPosition, Sizeable.Unit.PERCENTAGE);
        splitPanel.addSplitPositionChangeListener((AbstractSplitPanel.SplitPositionChangeListener & Serializable)event -> {
            Assert.assertFalse((boolean)event.isUserOriginated());
            Assert.assertTrue((previousPosition == event.getOldSplitPosition() ? 1 : 0) != 0);
            Assert.assertEquals((Object)Sizeable.Unit.PERCENTAGE, (Object)event.getOldSplitPositionUnit());
            Assert.assertTrue((newPosition == event.getSplitPosition() ? 1 : 0) != 0);
            Assert.assertEquals((Object)Sizeable.Unit.PIXELS, (Object)event.getSplitPositionUnit());
            executed.set(true);
        });
        splitPanel.setSplitPosition(newPosition, Sizeable.Unit.PIXELS);
        Assert.assertTrue((boolean)executed.get());
    }
}

