/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasValue;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.data.selection.SelectionServerRpc;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ComboBoxTest {
    private List<String> eventValues = new ArrayList<String>();

    @Test
    public void testResetValue() {
        ComboBox comboBox = new ComboBox();
        comboBox.setItems((Object[])new String[]{"one", "two"});
        comboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.eventValues.add((String)event.getValue());
            comboBox.setValue(null);
        });
        new MockUI().setContent((Component)comboBox);
        comboBox.getDataCommunicator().beforeClientResponse(true);
        ComponentTest.syncToClient((AbstractComponent)comboBox);
        String oneKey = comboBox.getDataCommunicator().getKeyMapper().key((Object)"one");
        ((SelectionServerRpc)ServerRpcManager.getRpcProxy((ClientConnector)comboBox, SelectionServerRpc.class)).select(oneKey);
        Assert.assertArrayEquals((String)"Unexpected values from selection events", (Object[])new Object[]{"one", null}, (Object[])this.eventValues.toArray());
        ComponentTest.assertEncodedStateProperties((ClientConnector)comboBox, "Selection change done by the listener should be sent to the client", "selectedItemKey");
    }
}

