/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasDataProvider;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.bov.Person;
import com.vaadin.event.selection.SingleSelectionEvent;
import com.vaadin.event.selection.SingleSelectionListener;
import com.vaadin.shared.Registration;
import com.vaadin.shared.data.DataCommunicatorClientRpc;
import com.vaadin.ui.AbstractSingleSelect;
import com.vaadin.ui.declarative.DesignContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractSingleSelectTest {
    private List<Person> selectionChanges;
    private List<Person> oldSelections;
    public static final Person PERSON_C = new Person("c", 3);
    public static final Person PERSON_B = new Person("b", 2);
    public static final Person PERSON_A = new Person("a", 1);
    public static final String RPC_INTERFACE = DataCommunicatorClientRpc.class.getName();
    private PersonListing listing;

    @Before
    public void initListing() {
        this.listing = new PersonListing();
        this.listing.setItems(new Person[]{PERSON_A, PERSON_B, PERSON_C});
        this.selectionChanges = new ArrayList<Person>();
        this.oldSelections = new ArrayList<Person>();
        this.listing.addSelectionListener((SingleSelectionListener & Serializable)event -> this.selectionChanges.add((Person)event.getValue()));
        this.listing.addSelectionListener((SingleSelectionListener & Serializable)event -> this.oldSelections.add((Person)event.getOldValue()));
    }

    @Test
    public void select() {
        this.listing.setValue(PERSON_B);
        Assert.assertTrue((boolean)this.listing.getSelectedItem().isPresent());
        Assert.assertEquals((Object)PERSON_B, this.listing.getSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_A));
        Assert.assertTrue((boolean)this.listing.isSelected(PERSON_B));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_B), (Object)this.listing.getSelectedItem());
        Assert.assertEquals(Arrays.asList(PERSON_B), this.selectionChanges);
        this.verifyValueChanges();
    }

    @Test
    public void selectDeselect() {
        this.listing.setValue(PERSON_B);
        this.listing.setValue(null);
        Assert.assertFalse((boolean)this.listing.getSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_A));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_B));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_C));
        Assert.assertFalse((boolean)this.listing.getSelectedItem().isPresent());
        Assert.assertEquals(Arrays.asList(PERSON_B, null), this.selectionChanges);
        this.verifyValueChanges();
    }

    @Test
    public void reselect() {
        this.listing.setValue(PERSON_B);
        this.listing.setValue(PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.listing.getSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_A));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_B));
        Assert.assertTrue((boolean)this.listing.isSelected(PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.listing.getSelectedItem());
        Assert.assertEquals(Arrays.asList(PERSON_B, PERSON_C), this.selectionChanges);
        this.verifyValueChanges();
    }

    @Test
    public void selectTwice() {
        this.listing.setValue(PERSON_C);
        this.listing.setValue(PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.listing.getSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_A));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_B));
        Assert.assertTrue((boolean)this.listing.isSelected(PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.listing.getSelectedItem());
        Assert.assertEquals(Arrays.asList(PERSON_C), this.selectionChanges);
        this.verifyValueChanges();
    }

    @Test
    public void deselectTwice() {
        this.listing.setValue(PERSON_C);
        this.listing.setValue(null);
        this.listing.setValue(null);
        Assert.assertFalse((boolean)this.listing.getSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_A));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_B));
        Assert.assertFalse((boolean)this.listing.isSelected(PERSON_C));
        Assert.assertFalse((boolean)this.listing.getSelectedItem().isPresent());
        Assert.assertEquals(Arrays.asList(PERSON_C, null), this.selectionChanges);
        this.verifyValueChanges();
    }

    @Test
    public void getValue() {
        this.listing.setSelectedItem(PERSON_B);
        Assert.assertEquals((Object)PERSON_B, (Object)this.listing.getValue());
        this.listing.setValue(null);
        Assert.assertNull((Object)this.listing.getValue());
        this.verifyValueChanges();
    }

    @Test
    public void getValue_isDelegatedTo_getSelectedItem() {
        AbstractSingleSelect select = (AbstractSingleSelect)Mockito.mock(AbstractSingleSelect.class);
        Optional<Object> selected = Optional.of(new Object());
        Mockito.when((Object)select.getSelectedItem()).thenReturn(selected);
        ((AbstractSingleSelect)Mockito.doCallRealMethod().when((Object)select)).getValue();
        Assert.assertSame((Object)selected.get(), (Object)select.getValue());
        selected = Optional.empty();
        Mockito.when((Object)select.getSelectedItem()).thenReturn(selected);
        Assert.assertNull((Object)select.getValue());
    }

    @Test
    public void setValue() {
        this.listing.setValue(PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.listing.getSelectedItem().get());
        this.listing.setValue(null);
        Assert.assertFalse((boolean)this.listing.getSelectedItem().isPresent());
        this.verifyValueChanges();
    }

    @Test
    public void setValue_isDelegatedTo_setSelectedItem() {
        AbstractSingleSelect select = (AbstractSingleSelect)Mockito.mock(AbstractSingleSelect.class);
        ((AbstractSingleSelect)Mockito.doCallRealMethod().when((Object)select)).setValue(Mockito.any());
        Object value = new Object();
        select.setValue(value);
        ((AbstractSingleSelect)Mockito.verify((Object)select)).setSelectedItem(value);
        select.setValue(null);
        ((AbstractSingleSelect)Mockito.verify((Object)select)).setSelectedItem(null);
    }

    @Test
    public void addValueChangeListener() {
        final AtomicReference selectionListener = new AtomicReference();
        final Registration registration = (Registration)Mockito.mock(Registration.class);
        final String value = "foo";
        AbstractSingleSelect<String> select = new AbstractSingleSelect<String>(){

            public Registration addSelectionListener(SingleSelectionListener<String> listener) {
                selectionListener.set(listener);
                return registration;
            }

            public String getValue() {
                return value;
            }

            protected Element writeItem(Element design, String item, DesignContext context) {
                return null;
            }

            protected void readItems(Element design, DesignContext context) {
            }

            public void setItems(Collection<String> items) {
                throw new UnsupportedOperationException("Not needed in this test");
            }

            public DataProvider<String, ?> getDataProvider() {
                return null;
            }
        };
        AtomicReference event = new AtomicReference();
        Registration actualRegistration = select.addValueChangeListener((HasValue.ValueChangeListener & Serializable)evt -> {
            Assert.assertNull(event.get());
            event.set(evt);
        });
        Assert.assertSame((Object)registration, (Object)actualRegistration);
        ((SingleSelectionListener)selectionListener.get()).selectionChange(new SingleSelectionEvent((AbstractSingleSelect)select, (Object)value, true));
        Assert.assertEquals((Object)select, (Object)((HasValue.ValueChangeEvent)event.get()).getComponent());
        Assert.assertEquals((Object)value, (Object)((HasValue.ValueChangeEvent)event.get()).getOldValue());
        Assert.assertEquals((Object)value, (Object)((HasValue.ValueChangeEvent)event.get()).getValue());
        Assert.assertTrue((boolean)((HasValue.ValueChangeEvent)event.get()).isUserOriginated());
    }

    private void verifyValueChanges() {
        if (!this.oldSelections.isEmpty()) {
            Assert.assertEquals(null, (Object)this.oldSelections.get(0));
            Assert.assertEquals((long)this.selectionChanges.size(), (long)this.oldSelections.size());
            for (int i = 0; i < this.oldSelections.size() - 1; ++i) {
                Assert.assertEquals((Object)this.selectionChanges.get(i), (Object)this.oldSelections.get(i + 1));
            }
        }
    }

    private static class PersonListing
    extends AbstractSingleSelect<Person>
    implements HasDataProvider<Person> {
        private PersonListing() {
        }

        protected Element writeItem(Element design, Person item, DesignContext context) {
            return null;
        }

        protected void readItems(Element design, DesignContext context) {
        }

        public DataProvider<Person, ?> getDataProvider() {
            return this.internalGetDataProvider();
        }

        public void setDataProvider(DataProvider<Person, ?> dataProvider) {
            this.internalSetDataProvider(dataProvider);
        }
    }
}

