/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.ui.TwinColSelect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractMultiSelectUsingIdTest {
    public TwinColSelect<ItemWithId> selectToTest;

    @Before
    public void setUp() {
        this.selectToTest = new TwinColSelect();
        ArrayList<ItemWithId> items = new ArrayList<ItemWithId>();
        items.add(new ItemWithId(3));
        items.add(new ItemWithId(2));
        items.add(new ItemWithId(1));
        items.add(new ItemWithId(8));
        items.add(new ItemWithId(7));
        items.add(new ItemWithId(4));
        items.add(new ItemWithId(6));
        ListDataProvider<ItemWithId> dataProvider = new ListDataProvider<ItemWithId>(items){

            public Object getId(ItemWithId item) {
                return item.getId();
            }
        };
        this.selectToTest.setDataProvider((DataProvider)dataProvider);
    }

    @Test
    public void selectTwiceSelectsOnce() {
        this.selectToTest.select((Object[])new ItemWithId[]{new ItemWithId(1)});
        this.assertSelectionOrder(1);
        this.selectToTest.select((Object[])new ItemWithId[]{new ItemWithId(1)});
        this.assertSelectionOrder(1);
    }

    @Test
    public void deselectWorks() {
        this.selectToTest.select((Object[])new ItemWithId[]{new ItemWithId(1)});
        this.selectToTest.deselect((Object[])new ItemWithId[]{new ItemWithId(1)});
        this.assertSelectionOrder(new Integer[0]);
    }

    private void assertSelectionOrder(Integer ... selectionOrder) {
        List<Integer> asList = Arrays.asList(selectionOrder);
        Assert.assertEquals(asList, this.selectToTest.getSelectedItems().stream().map(ItemWithId::getId).collect(Collectors.toList()));
    }

    public static class ItemWithId {
        private int id;

        public ItemWithId() {
        }

        public ItemWithId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

