/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.data.HasDataProvider;
import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.ui.AbstractListing;
import com.vaadin.ui.AbstractSingleSelect;
import com.vaadin.ui.declarative.DesignContext;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractListingTest {
    private static final String[] ITEM_ARRAY = new String[]{"Foo", "Bar", "Baz"};
    private TestListing listing;
    private List<String> items;

    @Before
    public void setUp() {
        this.items = new ArrayList<String>(Arrays.asList(ITEM_ARRAY));
        this.listing = new TestListing();
    }

    @Test
    public void testSetItemsWithCollection() {
        this.listing.setItems(this.items);
        LinkedList<String> list = new LinkedList<String>(this.items);
        try (Stream stream = this.listing.getDataProvider().fetch(new Query());){
            stream.forEach(str -> Assert.assertTrue((String)"Unexpected item in data provider", (boolean)list.remove(str)));
        }
        Assert.assertTrue((String)"Not all items from list were in data provider", (boolean)list.isEmpty());
    }

    @Test
    public void testSetItemsWithVarargs() {
        this.listing.setItems(ITEM_ARRAY);
        try (Stream stream = this.listing.getDataProvider().fetch(new Query());){
            stream.forEach(str -> Assert.assertTrue((String)"Unexpected item in data provider", (boolean)this.items.remove(str)));
        }
        Assert.assertTrue((String)"Not all items from list were in data provider", (boolean)this.items.isEmpty());
    }

    @Test
    public void testSetDataProvider() {
        ListDataProvider dataProvider = DataProvider.ofCollection(this.items);
        this.listing.setDataProvider((DataProvider<String, ?>)dataProvider);
        Assert.assertEquals((String)"setDataProvider did not set data provider", (Object)dataProvider, this.listing.getDataProvider());
        this.listing.setDataProvider((DataProvider<String, ?>)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> Stream.of(ITEM_ARRAY).skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> ITEM_ARRAY.length));
        Assert.assertNotEquals((String)"setDataProvider did not replace data provider", (Object)dataProvider, this.listing.getDataProvider());
    }

    @Test
    public void testAddDataGeneratorBeforeDataProvider() {
        CountGenerator generator = new CountGenerator();
        generator.extend((AbstractListing)this.listing);
        this.listing.setItems(new String[]{"Foo"});
        this.listing.runDataGeneration(true);
        Assert.assertEquals((String)"Generator should have been called once", (long)1L, (long)generator.callCount);
    }

    @Test
    public void testAddDataGeneratorAfterDataProvider() {
        CountGenerator generator = new CountGenerator();
        this.listing.setItems(new String[]{"Foo"});
        generator.extend((AbstractListing)this.listing);
        this.listing.runDataGeneration(true);
        Assert.assertEquals((String)"Generator should have been called once", (long)1L, (long)generator.callCount);
    }

    @Test
    public void testDataNotGeneratedTwice() {
        this.listing.setItems(new String[]{"Foo"});
        CountGenerator generator = new CountGenerator();
        generator.extend((AbstractListing)this.listing);
        this.listing.runDataGeneration(true);
        Assert.assertEquals((String)"Generator should have been called once", (long)1L, (long)generator.callCount);
        this.listing.runDataGeneration(false);
        Assert.assertEquals((String)"Generator should not have been called again", (long)1L, (long)generator.callCount);
    }

    @Test
    public void testRemoveDataGenerator() {
        this.listing.setItems(new String[]{"Foo"});
        CountGenerator generator = new CountGenerator();
        generator.extend((AbstractListing)this.listing);
        generator.remove();
        this.listing.runDataGeneration(true);
        Assert.assertEquals((String)"Generator should not have been called", (long)0L, (long)generator.callCount);
    }

    @Test
    public void testDataRefresh() {
        this.listing.setItems(new String[]{"Foo"});
        CountGenerator generator = new CountGenerator();
        generator.extend((AbstractListing)this.listing);
        this.listing.runDataGeneration(true);
        Assert.assertEquals((String)"Generator should have been called once", (long)1L, (long)generator.callCount);
        generator.refresh("Foo");
        this.listing.runDataGeneration(false);
        Assert.assertEquals((String)"Generator should have been called again", (long)2L, (long)generator.callCount);
    }

    private final class CountGenerator
    extends AbstractListing.AbstractListingExtension<String> {
        int callCount = 0;

        private CountGenerator() {
        }

        public void generateData(String data, JsonObject jsonObject) {
            ++this.callCount;
        }

        public void destroyData(String data) {
        }

        public void refresh(String data) {
            super.refresh((Object)data);
        }
    }

    private final class TestListing
    extends AbstractSingleSelect<String>
    implements HasDataProvider<String> {
        private TestListing() {
        }

        public void runDataGeneration(boolean initial) {
            super.getDataCommunicator().beforeClientResponse(initial);
        }

        protected Element writeItem(Element design, String item, DesignContext context) {
            return null;
        }

        protected void readItems(Element design, DesignContext context) {
        }

        public DataProvider<String, ?> getDataProvider() {
            return this.internalGetDataProvider();
        }

        public void setDataProvider(DataProvider<String, ?> dataProvider) {
            this.internalSetDataProvider(dataProvider);
        }
    }
}

