/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.navigator;

import com.vaadin.navigator.Navigator;
import com.vaadin.server.Page;
import com.vaadin.shared.Registration;
import java.io.Serializable;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Test;

public class UriFragmentManagerTest {
    @Test
    public void testGetSetUriFragment() {
        Page page = (Page)EasyMock.createMock(Page.class);
        Navigator.UriFragmentManager manager = new Navigator.UriFragmentManager(page);
        EasyMock.expect((Object)page.getUriFragment()).andReturn((Object)"");
        page.setUriFragment("!test", false);
        EasyMock.expect((Object)page.getUriFragment()).andReturn((Object)"!test");
        EasyMock.replay((Object[])new Object[]{page});
        Assert.assertEquals((String)"Incorrect fragment value", (Object)"", (Object)manager.getState());
        manager.setState("test");
        Assert.assertEquals((String)"Incorrect fragment value", (Object)"test", (Object)manager.getState());
    }

    @Test
    public void testListener() {
        IMocksControl control = EasyMock.createNiceControl();
        Navigator navigator = (Navigator)control.createMock(Navigator.class);
        Page page = (Page)control.createMock(Page.class);
        Navigator.UriFragmentManager manager = new Navigator.UriFragmentManager(page);
        manager.setNavigator(navigator);
        control.resetToNice();
        EasyMock.expect((Object)page.getUriFragment()).andReturn((Object)"!test");
        navigator.navigateTo("test");
        control.replay();
        page.setUriFragment("oldtest", true);
    }

    @Test
    public void setNavigator_someNavigatorInstance_uriFragmentChangedListenerIsRemoved() {
        TestPage page = new TestPage();
        Navigator.UriFragmentManager manager = new Navigator.UriFragmentManager((Page)page);
        manager.setNavigator((Navigator)EasyMock.createMock(Navigator.class));
        Assert.assertTrue((String)"addUriFragmentChangedListener() method is not called for the Page", (boolean)page.addUriFragmentCalled());
        Assert.assertFalse((String)"removeUriFragmentChangedListener() method is called for the Page", (boolean)page.removeUriFragmentCalled());
    }

    @Test
    public void setNavigator_nullNavigatorInstance_uriFragmentChangedListenerIsRemoved() {
        TestPage page = new TestPage();
        Navigator.UriFragmentManager manager = new Navigator.UriFragmentManager((Page)page);
        manager.setNavigator((Navigator)EasyMock.createMock(Navigator.class));
        manager.setNavigator(null);
        Assert.assertTrue((String)"removeUriFragmentChangedListener() method is not called for the Page", (boolean)page.removeUriFragmentCalled());
    }

    private static class TestPage
    extends Page {
        private boolean addUriFragmentCalled;
        private boolean removeUriFragmentCalled;

        public TestPage() {
            super(null, null);
        }

        public Registration addUriFragmentChangedListener(Page.UriFragmentChangedListener listener) {
            this.addUriFragmentCalled = true;
            return (Registration & Serializable)() -> {
                this.removeUriFragmentCalled = true;
            };
        }

        public void removeUriFragmentChangedListener(Page.UriFragmentChangedListener listener) {
            this.removeUriFragmentCalled = true;
        }

        boolean addUriFragmentCalled() {
            return this.addUriFragmentCalled;
        }

        boolean removeUriFragmentCalled() {
            return this.removeUriFragmentCalled;
        }
    }
}

