/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.server.component.window;

import com.vaadin.shared.ui.window.WindowMode;
import com.vaadin.shared.ui.window.WindowRole;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Window;
import com.vaadin.ui.declarative.DesignException;
import org.junit.Assert;
import org.junit.Test;

public class WindowDeclarativeTest
extends DeclarativeTestBase<Window> {
    @Test
    public void testDefault() {
        String design = "<vaadin-window>";
        Window expected = new Window();
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test
    public void testFeatures() {
        String design = "<vaadin-window position='100,100' window-mode='maximized' center modal resizable=false resize-lazy closable=false draggable=false close-shortcut='ctrl-alt-escape' assistive-prefix='Hello' assistive-postfix='World' assistive-role='alertdialog' tab-stop-enabled tab-stop-top-assistive-text='Do not move above the window' tab-stop-bottom-assistive-text='End of window'></vaadin-window>";
        Window expected = new Window();
        expected.setPositionX(100);
        expected.setPositionY(100);
        expected.setWindowMode(WindowMode.MAXIMIZED);
        expected.center();
        expected.setModal(!expected.isModal());
        expected.setResizable(!expected.isResizable());
        expected.setResizeLazy(!expected.isResizeLazy());
        expected.setClosable(!expected.isClosable());
        expected.setDraggable(!expected.isDraggable());
        expected.removeAllCloseShortcuts();
        expected.addCloseShortcut(27, new int[]{18, 17});
        expected.setAssistivePrefix("Hello");
        expected.setAssistivePostfix("World");
        expected.setAssistiveRole(WindowRole.ALERTDIALOG);
        expected.setTabStopEnabled(!expected.isTabStopEnabled());
        expected.setTabStopTopAssistiveText("Do not move above the window");
        expected.setTabStopBottomAssistiveText("End of window");
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test
    public void testMultiCloseShortcuts() {
        Window expected = new Window();
        expected.addCloseShortcut(32, new int[0]);
        expected.addCloseShortcut(37, new int[]{18, 17});
        expected.addCloseShortcut(37, new int[]{17, 18});
        expected.addCloseShortcut(39, new int[]{17});
        String design = "<vaadin-window close-shortcut='escape spacebar ctrl-alt-left ctrl-right' />";
        this.testRead(design, expected);
        this.testWrite(design, expected);
        expected.removeCloseShortcut(32, new int[0]);
        design = "<vaadin-window close-shortcut='escape ctrl-alt-left ctrl-right' />";
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test
    public void testInvalidPosition() {
        this.assertInvalidPosition("");
        this.assertInvalidPosition("1");
        this.assertInvalidPosition("100,100.1");
        this.assertInvalidPosition("x");
        this.assertInvalidPosition("2,foo");
    }

    protected void assertInvalidPosition(String position) {
        try {
            this.read("<vaadin-window position='" + position + "'>");
            Assert.fail((String)("Invalid position '" + position + "' should throw"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testChildContent() {
        String design = "<vaadin-window>" + this.createElement((Component)new Button("OK")) + "</vaadin-window>";
        Window expected = new Window();
        expected.setContent((Component)new Button("OK"));
        this.testRead(design, expected);
        this.testWrite(design, expected);
    }

    @Test(expected=DesignException.class)
    public void testMultipleContentChildren() {
        String design = "<vaadin-window>" + this.createElement((Component)new Label("Hello")) + this.createElement((Component)new Button("OK")) + "</vaadin-window>";
        this.read(design);
    }

    @Test
    public void testAssistiveDescription() {
        Label assistive1 = new Label("Assistive text");
        Label assistive2 = new Label("More assistive text");
        String design = "<vaadin-window>" + this.createElement((Component)assistive1).attr(":assistive-description", true) + this.createElement((Component)new Button("OK")) + this.createElement((Component)assistive2).attr(":assistive-description", true);
        Window expected = new Window();
        expected.setContent((Component)new Button("OK"));
        expected.setAssistiveDescription(new Component[]{assistive1, assistive2});
        this.testRead(design, expected);
        String written = "<vaadin-window>" + this.createElement((Component)new Button("OK")) + this.createElement((Component)assistive1).attr(":assistive-description", true) + this.createElement((Component)assistive2).attr(":assistive-description", true);
        this.testWrite(written, expected);
    }
}

